/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process;

import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.CorbaServer;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ProxyManager;
import org.cristalise.kernel.entity.proxy.ProxyServer;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.Lookup;
import org.cristalise.kernel.lookup.LookupManager;
import org.cristalise.kernel.persistency.TransactionManager;
import org.cristalise.kernel.process.AbstractMain;
import org.cristalise.kernel.process.Bootstrap;
import org.cristalise.kernel.process.auth.Authenticator;
import org.cristalise.kernel.process.module.ModuleManager;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.process.resource.DefaultResourceImportHandler;
import org.cristalise.kernel.process.resource.Resource;
import org.cristalise.kernel.process.resource.ResourceImportHandler;
import org.cristalise.kernel.process.resource.ResourceLoader;
import org.cristalise.kernel.scripting.ScriptConsole;
import org.cristalise.kernel.utils.CastorXMLUtility;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.kernel.utils.ObjectProperties;
import org.omg.CORBA.ORB;

public class Gateway {
    private static ObjectProperties mC2KProps = new ObjectProperties();
    private static ModuleManager mModules;
    private static ORB mORB;
    private static boolean orbDestroyed;
    private static Lookup mLookup;
    private static LookupManager mLookupManager;
    private static TransactionManager mStorage;
    private static ProxyManager mProxyManager;
    private static ProxyServer mProxyServer;
    private static CorbaServer mCorbaServer;
    private static CastorXMLUtility mMarshaller;
    private static ResourceLoader mResource;
    private static HashMap<BuiltInResources, ResourceImportHandler> resourceImportHandlerCache;

    private Gateway() {
    }

    public static void init(Properties props) throws InvalidDataException {
        Gateway.init(props, null);
    }

    public static void init(Properties props, ResourceLoader res) throws InvalidDataException {
        Properties allModuleProperties;
        mC2KProps.clear();
        orbDestroyed = false;
        mResource = res;
        if (mResource == null) {
            mResource = new Resource();
        }
        Logger.msg("Gateway.init() - Kernel version: " + Gateway.getKernelVersion());
        try {
            mMarshaller = new CastorXMLUtility(mResource, props, mResource.getKernelResourceURL("mapFiles/"));
        }
        catch (MalformedURLException e1) {
            throw new InvalidDataException("Invalid Resource Location");
        }
        try {
            mModules = new ModuleManager(AbstractMain.isServer);
            allModuleProperties = mModules.loadModules(mResource.getModuleDefURLs());
        }
        catch (Exception e) {
            Logger.error(e);
            throw new InvalidDataException("Could not load module definitions.");
        }
        Enumeration<?> e = allModuleProperties.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            mC2KProps.put(propName, allModuleProperties.get(propName));
        }
        if (props != null) {
            mC2KProps.putAll((Map<?, ?>)props);
        }
        Logger.msg("Gateway.init() - DONE");
        Gateway.dumpC2KProps(7);
    }

    @Deprecated
    public static void startServer(Authenticator auth) throws InvalidDataException, CannotManageException {
        Gateway.startServer();
    }

    public static void startServer() throws InvalidDataException, CannotManageException {
        try {
            if (!(mLookup instanceof LookupManager)) {
                throw new CannotManageException("Lookup implementation is not a LookupManager. Cannot write to directory");
            }
            mLookupManager = (LookupManager)mLookup;
            mLookupManager.initializeDirectory();
            mProxyServer = new ProxyServer(mC2KProps.getProperty("ItemServer.name"));
            String serverName = mC2KProps.getProperty("ItemServer.name");
            if (serverName != null) {
                mC2KProps.put("com.sun.CORBA.ORBServerHost", serverName);
            }
            String serverPort = mC2KProps.getProperty("ItemServer.iiop", "1500");
            mC2KProps.put("com.sun.CORBA.ORBServerPort", serverPort);
            mC2KProps.put("com.sun.CORBA.POA.ORBServerId", "1");
            mC2KProps.put("com.sun.CORBA.POA.ORBPersistentServerPort", serverPort);
            mC2KProps.put("com.sun.CORBA.codeset.charsets", "0x05010001, 0x00010109");
            mC2KProps.put("com.sun.CORBA.codeset.wcharsets", "0x00010109, 0x05010001");
            orbDestroyed = false;
            mORB = ORB.init((String[])new String[0], (Properties)mC2KProps);
            Logger.msg("Gateway.startServer() - ORB initialised. ORB class:'" + mORB.getClass().getName() + "'");
            mCorbaServer = new CorbaServer();
            Bootstrap.run();
            Logger.msg("Gateway.startServer() - Server '" + serverName + "' STARTED.");
        }
        catch (Exception ex) {
            Logger.error(ex);
            Logger.die("Exception starting server components. Shutting down.");
        }
    }

    public static ModuleManager getModuleManager() {
        return mModules;
    }

    public static Authenticator connect() throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        try {
            Authenticator auth = Gateway.getAuthenticator();
            if (!auth.authenticate("System")) {
                throw new InvalidDataException("Server authentication failed");
            }
            if (mLookup != null) {
                mLookup.close();
            }
            mLookup = (Lookup)mC2KProps.getInstance("Lookup");
            mLookup.open(auth);
            mStorage = new TransactionManager(auth);
            mProxyManager = new ProxyManager();
            Logger.msg("Gateway.connect() - DONE.");
            return auth;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            Logger.error(ex);
            throw new InvalidDataException("Cannot connect server process. Please check config.");
        }
    }

    public static AgentProxy connect(String agentName, String agentPassword, String resource) throws InvalidDataException, ObjectNotFoundException, PersistencyException {
        Authenticator auth = Gateway.getAuthenticator();
        if (!auth.authenticate(agentName, agentPassword, resource)) {
            throw new InvalidDataException("Login failed");
        }
        try {
            if (mLookup != null) {
                mLookup.close();
            }
            mLookup = (Lookup)mC2KProps.getInstance("Lookup");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            Logger.error(ex);
            throw new InvalidDataException("Lookup " + mC2KProps.getString("Lookup") + " could not be instantiated");
        }
        mLookup.open(auth);
        mStorage = new TransactionManager(auth);
        mProxyManager = new ProxyManager();
        AgentPath agentPath = mLookup.getAgentPath(agentName);
        AgentProxy agent = (AgentProxy)mProxyManager.getProxy(agentPath);
        agent.setAuthObj(auth);
        ScriptConsole.setUser(agent);
        mModules.setUser(agent);
        mModules.runScripts("startup");
        Logger.msg("Gateway.connect(agent) - DONE.");
        return agent;
    }

    public static AgentProxy login(String agentName, String agentPassword, String resource) throws InvalidDataException, ObjectNotFoundException {
        Authenticator auth = Gateway.getAuthenticator();
        if (!auth.authenticate(agentName, agentPassword, resource)) {
            throw new InvalidDataException("Login failed");
        }
        AgentPath agentPath = mLookup.getAgentPath(agentName);
        AgentProxy agent = (AgentProxy)mProxyManager.getProxy(agentPath);
        agent.setAuthObj(auth);
        return agent;
    }

    public static Authenticator getAuthenticator() throws InvalidDataException {
        try {
            return (Authenticator)mC2KProps.getInstance("Authenticator");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            Logger.error(ex);
            throw new InvalidDataException("Authenticator " + mC2KProps.getString("Authenticator") + " could not be instantiated");
        }
    }

    public static AgentProxy connect(String agentName, String agentPassword) throws InvalidDataException, ObjectNotFoundException, PersistencyException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        return Gateway.connect(agentName, agentPassword, null);
    }

    public static void close() {
        if (mModules != null) {
            mModules.runScripts("shutdown");
        }
        if (mCorbaServer != null) {
            mCorbaServer.close();
        }
        mCorbaServer = null;
        if (mStorage != null) {
            mStorage.close();
        }
        mStorage = null;
        if (mLookup != null) {
            mLookup.close();
        }
        mLookup = null;
        mLookupManager = null;
        if (mProxyManager != null) {
            mProxyManager.shutdown();
        }
        if (mProxyServer != null) {
            mProxyServer.shutdownServer();
        }
        mProxyManager = null;
        mProxyServer = null;
        Logger.closeConsole();
        if (!orbDestroyed) {
            Gateway.getORB().destroy();
            orbDestroyed = true;
            mORB = null;
        }
        mModules = null;
        mResource = null;
        mMarshaller = null;
        mC2KProps.clear();
        Logger.removeAll();
    }

    public static ORB getORB() {
        if (orbDestroyed) {
            throw new RuntimeException("Gateway has been closed. ORB is destroyed. ");
        }
        if (mORB == null) {
            mC2KProps.put("com.sun.CORBA.codeset.charsets", "0x05010001, 0x00010109");
            mC2KProps.put("com.sun.CORBA.codeset.wcharsets", "0x00010109, 0x05010001");
            mORB = ORB.init((String[])new String[0], (Properties)mC2KProps);
        }
        return mORB;
    }

    public static Lookup getLookup() {
        return mLookup;
    }

    public static LookupManager getLookupManager() throws CannotManageException {
        if (mLookupManager == null) {
            throw new CannotManageException("No Lookup Manager created. Not a server process.");
        }
        return mLookupManager;
    }

    public static CorbaServer getCorbaServer() {
        return mCorbaServer;
    }

    public static TransactionManager getStorage() {
        return mStorage;
    }

    public static CastorXMLUtility getMarshaller() {
        return mMarshaller;
    }

    public static ResourceLoader getResource() {
        return mResource;
    }

    public static ProxyManager getProxyManager() {
        return mProxyManager;
    }

    public static ProxyServer getProxyServer() {
        return mProxyServer;
    }

    public static String getCentreId() {
        return Gateway.getProperties().getString("LocalCentre");
    }

    public static Enumeration<?> propertyNames() {
        return mC2KProps.propertyNames();
    }

    public static void dumpC2KProps(int logLevel) {
        if (!Logger.doLog(logLevel)) {
            return;
        }
        mC2KProps.dumpProps(logLevel);
    }

    public static ObjectProperties getProperties() {
        return mC2KProps;
    }

    public static String getKernelVersion() {
        try {
            return mResource.getTextResource(null, "textFiles/version.txt");
        }
        catch (Exception ex) {
            return "No version info found";
        }
    }

    @Deprecated
    public static ResourceImportHandler getResourceImportHandler(String resType) throws Exception {
        return Gateway.getResourceImportHandler(BuiltInResources.getValue(resType));
    }

    public static ResourceImportHandler getResourceImportHandler(BuiltInResources resType) throws Exception {
        if (resourceImportHandlerCache.containsKey((Object)resType)) {
            return resourceImportHandlerCache.get((Object)resType);
        }
        ResourceImportHandler handler = null;
        if (Gateway.getProperties().containsKey("ResourceImportHandler." + (Object)((Object)resType))) {
            try {
                handler = (ResourceImportHandler)Gateway.getProperties().getInstance("ResourceImportHandler." + (Object)((Object)resType));
            }
            catch (Exception ex) {
                Logger.error(ex);
                Logger.error("Exception loading ResourceHandler for " + (Object)((Object)resType) + ". Using default.");
            }
        }
        if (handler == null) {
            handler = new DefaultResourceImportHandler(resType);
        }
        resourceImportHandlerCache.put(resType, handler);
        return handler;
    }

    static {
        orbDestroyed = false;
        mLookupManager = null;
        resourceImportHandlerCache = new HashMap();
    }
}

