/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process.resource;

import java.util.HashSet;
import java.util.Set;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.process.resource.ResourceImportHandler;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.querying.Query;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.utils.DescriptionObject;
import org.cristalise.kernel.utils.LocalObjectLoader;

public class DefaultResourceImportHandler
implements ResourceImportHandler {
    BuiltInResources type;
    DomainPath typeRootPath;
    PropertyDescriptionList props;

    public DefaultResourceImportHandler(BuiltInResources resType) throws Exception {
        this.type = resType;
        this.typeRootPath = new DomainPath(this.type.getTypeRoot());
        this.props = (PropertyDescriptionList)Gateway.getMarshaller().unmarshall(Gateway.getResource().getTextResource(null, "boot/property/" + (Object)((Object)resType) + "Prop.xml"));
    }

    @Deprecated
    public DefaultResourceImportHandler(String resType) throws Exception {
        this(BuiltInResources.getValue(resType));
    }

    @Override
    public CollectionArrayList getCollections(String name, String ns, String location, Integer version) throws Exception {
        return this.getCollections(name, version, Gateway.getResource().getTextResource(ns, location));
    }

    @Override
    public CollectionArrayList getCollections(String name, Integer version, Outcome outcome) throws Exception {
        return this.getCollections(name, version, outcome.getData());
    }

    private CollectionArrayList getCollections(String name, Integer version, String xml) throws Exception {
        if (this.type == BuiltInResources.SCHEMA_RESOURCE) {
            return new Schema(name, version, null, xml).makeDescCollections();
        }
        if (this.type == BuiltInResources.SCRIPT_RESOURCE) {
            return new Script(name, version, null, xml).makeDescCollections();
        }
        if (this.type == BuiltInResources.QUERY_RESOURCE) {
            return new Query(name, version, null, xml).makeDescCollections();
        }
        DescriptionObject descObject = (DescriptionObject)Gateway.getMarshaller().unmarshall(xml);
        descObject.setVersion(version);
        return descObject.makeDescCollections();
    }

    @Override
    public DomainPath getTypeRoot() {
        return this.typeRootPath;
    }

    @Override
    public String getName() {
        return this.type.getSchemaName();
    }

    @Override
    public DomainPath getPath(String name, String ns) throws Exception {
        return new DomainPath(this.type.getTypeRoot() + "/" + (ns == null ? "kernel" : ns) + '/' + name);
    }

    @Override
    public Set<Outcome> getResourceOutcomes(String name, String ns, String location, Integer version) throws Exception {
        HashSet<Outcome> retArr = new HashSet<Outcome>();
        String data = Gateway.getResource().getTextResource(ns, location);
        if (data == null) {
            throw new Exception("No data found for " + this.type.getSchemaName() + " " + name);
        }
        Outcome resOutcome = new Outcome(0, data, LocalObjectLoader.getSchema(this.type.getSchemaName(), 0));
        retArr.add(resOutcome);
        return retArr;
    }

    @Override
    public PropertyDescriptionList getPropDesc() throws Exception {
        return this.props;
    }

    @Override
    public String getWorkflowName() throws Exception {
        return this.type.getWorkflowDef();
    }
}

