/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.querying;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.outcome.OutcomeValidator;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.querying.Parameter;
import org.cristalise.kernel.querying.QueryParsingException;
import org.cristalise.kernel.scripting.ParameterException;
import org.cristalise.kernel.scripting.ScriptParsingException;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.DescriptionObject;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class Query
implements DescriptionObject {
    private String name = "";
    private Integer version = null;
    private ItemPath itemPath;
    private String language;
    private String query;
    private ArrayList<Parameter> parameters = new ArrayList();

    public Query() {
    }

    public Query(String n, int v, ItemPath path, String xml) throws QueryParsingException {
        this.name = n;
        this.version = v;
        this.itemPath = path;
        this.parseXML(xml);
    }

    public Query(String n, int v, String xml) throws QueryParsingException {
        this.name = n;
        this.version = v;
        this.parseXML(xml);
    }

    public Query(String xml) throws QueryParsingException {
        this.parseXML(xml);
    }

    @Override
    public String getItemID() {
        return this.itemPath.getUUID().toString();
    }

    public boolean hasParameters() {
        return this.parameters != null && this.parameters.size() > 0;
    }

    public Parameter getParameter(String name) {
        for (Parameter p : this.parameters) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public void setStringParameter(String name, Object value) {
        if (value == null) {
            return;
        }
        Parameter p = this.getParameter(name);
        if (p == null) {
            p = new Parameter(name, String.class, value);
            this.parameters.add(p);
        } else {
            p.setValue(value);
        }
    }

    public void setParemeterValues(String itemUUID, Object schemaName, CastorHashMap actProps) {
        for (Parameter p : this.parameters) {
            p.setValue(actProps.get(p.getName()));
        }
        this.setMandatoryParemeters(itemUUID, schemaName);
    }

    public void setMandatoryParemeters(String uuid, Object schemaName) {
        this.setStringParameter("itemUUID", uuid);
        this.setStringParameter("schemaName", schemaName);
    }

    public void validateXML(String xml) throws InvalidDataException, ObjectNotFoundException {
        Schema querySchema = Gateway.getLookup() == null ? new Schema("Query", 0, Gateway.getResource().getTextResource(null, "boot/OD/Query.xsd")) : LocalObjectLoader.getSchema("Query", 0);
        OutcomeValidator validator = new OutcomeValidator(querySchema);
        String error = validator.validate(xml);
        if (!StringUtils.isBlank((CharSequence)error)) {
            Logger.error("Query.validateXML() - $error");
            Logger.error("\n============== XML ==============\n" + xml + "\n=================================\n");
            throw new InvalidDataException(error);
        }
        Logger.msg(5, "Query.validateXML() - DONE");
    }

    public void parseXML(String xml) throws QueryParsingException {
        if (StringUtils.isBlank((CharSequence)xml) || "<NULL/>".equals(xml)) {
            Logger.warning("Query.parseXML() - query XML was NULL!");
            return;
        }
        if (Logger.doLog(8)) {
            Logger.msg("Query.parseXML() - xml:\n" + xml);
        }
        try {
            this.validateXML(xml);
            DocumentBuilder domBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document queryDoc = domBuilder.parse(new InputSource(new StringReader(xml)));
            if (queryDoc.getDocumentElement().hasAttribute("name")) {
                this.name = queryDoc.getDocumentElement().getAttribute("name");
            }
            if (queryDoc.getDocumentElement().hasAttribute("version")) {
                this.version = Integer.valueOf(queryDoc.getDocumentElement().getAttribute("version"));
            }
            this.parseQueryTag(queryDoc.getElementsByTagName("query"));
            this.parseParameterTag(queryDoc.getElementsByTagName("parameter"));
        }
        catch (Exception ex) {
            Logger.error(ex);
            throw new QueryParsingException("Error parsing Query XML : " + ex.toString());
        }
    }

    private void parseQueryTag(NodeList querytList) throws QueryParsingException {
        Element queryElem = (Element)querytList.item(0);
        if (!queryElem.hasAttribute("language")) {
            throw new QueryParsingException("Query data incomplete, must specify language");
        }
        this.language = queryElem.getAttribute("language");
        Logger.msg(6, "Query.parseQueryTag() - Query Language:" + this.language);
        NodeList queryChildNodes = queryElem.getChildNodes();
        if (queryChildNodes.getLength() != 1) {
            throw new QueryParsingException("More than one child element found under query tag. Query characters may need escaping - suggest convert to CDATA section");
        }
        if (!(queryChildNodes.item(0) instanceof Text)) {
            throw new QueryParsingException("Child element of query tag was not text");
        }
        this.query = ((Text)queryChildNodes.item(0)).getData();
        Logger.msg(6, "Query.parseQueryTag() - query:" + this.query);
    }

    private void parseParameterTag(NodeList paramList) throws ScriptParsingException, ParameterException, ClassNotFoundException {
        for (int i = 0; i < paramList.getLength(); ++i) {
            Element param = (Element)paramList.item(i);
            if (!param.hasAttribute("name") || !param.hasAttribute("type")) {
                throw new ScriptParsingException("Incomplete Query Parameter: must have name and type");
            }
            this.parameters.add(new Parameter(param.getAttribute("name"), param.getAttribute("type")));
        }
    }

    public String getQueryXML() {
        StringBuffer sb = new StringBuffer("<cristalquery name='" + this.name + "' version='" + this.version + "'>");
        for (Parameter p : this.parameters) {
            sb.append("<parameter name='" + p.getName() + "' type='" + p.getType().getName() + "'/>");
        }
        sb.append("<query language='" + this.language + "'>" + "<![CDATA[" + this.query + "]]></query>");
        sb.append("</cristalquery>");
        if (Logger.doLog(8)) {
            Logger.msg("Query.getQueryXML() - xml:\n" + sb);
        }
        return sb.toString();
    }

    @Override
    public CollectionArrayList makeDescCollections() throws InvalidDataException, ObjectNotFoundException {
        return new CollectionArrayList();
    }

    @Override
    public void export(Writer imports, File dir) throws InvalidDataException, ObjectNotFoundException, IOException {
        String resType = BuiltInResources.QUERY_RESOURCE.getTypeCode();
        FileStringUtility.string2File(new File(new File(dir, resType), this.getName() + (this.getVersion() == null ? "" : "_" + this.getVersion()) + ".xml"), this.getQueryXML());
        if (imports != null) {
            imports.write("<Resource name=\"" + this.getName() + "\" " + (this.getItemPath() == null ? "" : "id=\"" + this.getItemID() + "\" ") + (this.getVersion() == null ? "" : "version=\"" + this.getVersion() + "\" ") + "type=\"" + resType + "\">boot/" + resType + "/" + this.getName() + (this.getVersion() == null ? "" : "_" + this.getVersion()) + ".xml</Resource>\n");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    @Override
    public ItemPath getItemPath() {
        return this.itemPath;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getQuery() {
        return this.query;
    }

    public ArrayList<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setVersion(Integer version) {
        this.version = version;
    }

    @Override
    public void setItemPath(ItemPath itemPath) {
        this.itemPath = itemPath;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setParameters(ArrayList<Parameter> parameters) {
        this.parameters = parameters;
    }
}

