/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.collection;

import java.util.StringTokenizer;
import org.cristalise.kernel.collection.Aggregation;
import org.cristalise.kernel.collection.CollectionMember;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.utils.Logger;

public class AggregationMember
extends GraphableVertex
implements CollectionMember {
    private ItemPath mItemPath = null;
    private ItemProxy mItem = null;
    private Aggregation mCollection = null;
    private String mClassProps = null;
    private String mItemName = null;

    public void setCollection(Aggregation aggregation) {
        this.mCollection = aggregation;
    }

    public void setClassProps(String props) {
        this.mClassProps = props;
    }

    @Override
    public ItemPath getItemPath() {
        return this.mItemPath;
    }

    public Aggregation getCollection() {
        return this.mCollection;
    }

    @Override
    public String getClassProps() {
        return this.mClassProps;
    }

    @Override
    public void assignItem(ItemPath itemPath) throws InvalidCollectionModification {
        if (itemPath != null) {
            if (this.mClassProps == null || this.getProperties() == null) {
                throw new InvalidCollectionModification("ClassProps not yet set. Cannot check membership validity.");
            }
            StringTokenizer sub = new StringTokenizer(this.mClassProps, ",");
            while (sub.hasMoreTokens()) {
                String aClassProp = sub.nextToken();
                try {
                    String memberValue = (String)this.getProperties().get(aClassProp);
                    Property ItemProperty = (Property)Gateway.getStorage().get(itemPath, "Property/" + aClassProp, null);
                    if (ItemProperty == null) {
                        throw new InvalidCollectionModification("Property " + aClassProp + " does not exist for item " + itemPath);
                    }
                    if (ItemProperty.getValue() != null && ItemProperty.getValue().equalsIgnoreCase(memberValue)) continue;
                    throw new InvalidCollectionModification("Value of mandatory prop " + aClassProp + " does not match: " + ItemProperty.getValue() + "!=" + memberValue);
                }
                catch (InvalidCollectionModification ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    Logger.error(ex);
                    throw new InvalidCollectionModification("Error checking properties");
                }
            }
        }
        this.mItemPath = itemPath;
        this.mItem = null;
        this.mItemName = null;
    }

    @Override
    public void clearItem() {
        this.mItemPath = null;
        this.mItem = null;
        this.mItemName = null;
    }

    @Override
    public ItemProxy resolveItem() throws ObjectNotFoundException {
        if (this.mItem == null && this.mItemPath != null) {
            this.mItem = Gateway.getProxyManager().getProxy(this.mItemPath);
        }
        return this.mItem;
    }

    public String getItemName() {
        if (this.mItemName == null) {
            if (this.mItemPath != null) {
                try {
                    this.mItemName = this.resolveItem().getName();
                }
                catch (ObjectNotFoundException ex) {
                    Logger.error((Throwable)((Object)ex));
                    this.mItemName = "Error (" + this.mItemPath + ")";
                }
            } else {
                this.mItemName = "Empty";
            }
        }
        return this.mItemName;
    }

    public void setChildUUID(String uuid) throws InvalidCollectionModification, InvalidItemPathException {
        this.mItemPath = new ItemPath(uuid);
        this.mItemName = null;
    }

    @Override
    public String getChildUUID() {
        if (this.getItemPath() == null) {
            return null;
        }
        return this.getItemPath().getUUID().toString();
    }
}

