/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.collection;

import java.util.ArrayList;
import java.util.List;
import org.cristalise.kernel.collection.BuiltInCollections;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.DependencyMember;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.ActivityDef;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.KeyValuePair;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;

public class Dependency
extends Collection<DependencyMember> {
    protected CastorHashMap mProperties = new CastorHashMap();
    protected String mClassProps = "";

    public Dependency() {
        this.setName("Dependency");
    }

    public Dependency(String name) {
        this.setName(name);
    }

    public Dependency(String name, Integer version) {
        this.setName(name);
        this.setVersion(version);
    }

    public Dependency(BuiltInCollections collection) {
        this(collection.getName());
    }

    public Dependency(BuiltInCollections collection, Integer version) {
        this(collection.getName(), version);
    }

    public CastorHashMap getProperties() {
        return this.mProperties;
    }

    public void setProperties(CastorHashMap props) {
        this.mProperties = props;
    }

    public KeyValuePair[] getKeyValuePairs() {
        return this.mProperties.getKeyValuePairs();
    }

    public void setKeyValuePairs(KeyValuePair[] pairs) {
        this.mProperties.setKeyValuePairs(pairs);
    }

    public void setClassProps(String classProps) {
        this.mClassProps = classProps;
    }

    public String getClassProps() {
        return this.mClassProps;
    }

    public DependencyMember addMember(ItemPath itemPath) throws InvalidCollectionModification, ObjectAlreadyExistsException {
        if (itemPath == null) {
            throw new InvalidCollectionModification("Cannot add empty slot to Dependency collection");
        }
        if (this.contains(itemPath)) {
            throw new ObjectAlreadyExistsException("Item " + itemPath + " already exists in Dependency " + this.getName());
        }
        DependencyMember depMember = new DependencyMember();
        depMember.setID(this.getCounter());
        depMember.setProperties((CastorHashMap)this.mProperties.clone());
        depMember.setClassProps(this.mClassProps);
        depMember.assignItem(itemPath);
        this.mMembers.list.add(depMember);
        Logger.msg(8, "Dependency.addMember(" + itemPath + ") added to children.");
        return depMember;
    }

    public List<DependencyMember> compare(Dependency other) {
        ArrayList<DependencyMember> newMembers = new ArrayList<DependencyMember>();
        for (DependencyMember thisMember : other.getMembers().list) {
            if (this.contains(thisMember.getItemPath())) continue;
            newMembers.add(thisMember);
        }
        return newMembers;
    }

    @Override
    public DependencyMember addMember(ItemPath itemPath, CastorHashMap props, String classProps) throws InvalidCollectionModification, ObjectAlreadyExistsException {
        String key;
        if (itemPath == null) {
            throw new InvalidCollectionModification("Cannot add empty slot to Dependency collection");
        }
        if (this.contains(itemPath)) {
            throw new ObjectAlreadyExistsException("Item " + itemPath + " already exists in Dependency " + this.getName());
        }
        if (classProps != null && !classProps.equals(this.mClassProps)) {
            throw new InvalidCollectionModification("Cannot change classProps in dependency member");
        }
        DependencyMember depMember = new DependencyMember();
        depMember.setID(this.getCounter());
        CastorHashMap newProps = new CastorHashMap();
        for (Object name : props.keySet()) {
            key = (String)name;
            newProps.put(key, props.get(key));
        }
        for (Object name : this.mProperties.keySet()) {
            key = (String)name;
            newProps.put(key, this.mProperties.get(key));
        }
        depMember.setProperties(newProps);
        depMember.setClassProps(this.mClassProps);
        depMember.assignItem(itemPath);
        this.mMembers.list.add(depMember);
        Logger.msg(8, "Dependency.addMember(" + itemPath + ") added to children.");
        return depMember;
    }

    @Override
    public void removeMember(int memberId) throws ObjectNotFoundException {
        for (DependencyMember element : this.mMembers.list) {
            if (element.getID() != memberId) continue;
            this.mMembers.list.remove(element);
            return;
        }
        throw new ObjectNotFoundException("Collection name:" + this.getName() + " does not contains Member id:" + memberId);
    }

    public void addToItemProperties(PropertyArrayList props) throws InvalidDataException, ObjectNotFoundException {
        Logger.msg(2, "Dependency.addToItemProperties(" + this.getName() + ") - Starting ...");
        BuiltInCollections builtInColl = BuiltInCollections.getValue(this.getName());
        block7: for (DependencyMember member : this.getMembers().list) {
            String memberUUID = member.getChildUUID();
            Integer memberVer = LocalObjectLoader.deriveVersionNumber(member.getBuiltInProperty(BuiltInVertexProperties.VERSION));
            if (memberVer == null) {
                throw new InvalidDataException("Version is null for Collection:" + this.getName() + ", MemberUUID:" + memberUUID);
            }
            if (this.convertToItemPropertyByScript(props, member) || builtInColl == null) continue;
            Logger.msg(5, "Dependency.addToItemProperties() - BuiltIn Dependency:" + this.getName() + " memberUUID:" + memberUUID);
            switch (builtInColl) {
                case SCHEMA: {
                    LocalObjectLoader.getSchema(memberUUID, memberVer);
                    props.put(new Property(BuiltInItemProperties.SCHEMA_URN, memberUUID + ":" + memberVer));
                    continue block7;
                }
                case SCRIPT: {
                    LocalObjectLoader.getScript(memberUUID, memberVer);
                    props.put(new Property(BuiltInItemProperties.SCRIPT_URN, memberUUID + ":" + memberVer));
                    continue block7;
                }
                case QUERY: {
                    LocalObjectLoader.getQuery(memberUUID, memberVer);
                    props.put(new Property(BuiltInItemProperties.QUERY_URN, memberUUID + ":" + memberVer));
                    continue block7;
                }
                case STATE_MACHINE: {
                    if (!Gateway.getProperties().getBoolean("Dependency.addStateMachineURN", false)) continue block7;
                    LocalObjectLoader.getStateMachine(memberUUID, memberVer);
                    props.put(new Property(BuiltInItemProperties.STATE_MACHINE_URN, memberUUID + ":" + memberVer));
                    continue block7;
                }
                case WORKFLOW: {
                    if (!Gateway.getProperties().getBoolean("Dependency.addWorkflowURN", false)) continue block7;
                    LocalObjectLoader.getCompActDef(memberUUID, memberVer);
                    props.put(new Property(BuiltInItemProperties.WORKFLOW_URN, memberUUID + ":" + memberVer));
                    continue block7;
                }
            }
            Logger.msg(8, "Dependency.addToItemProperties() - Cannot handle BuiltIn Dependency:" + this.getName());
        }
    }

    private boolean convertToItemPropertyByScript(PropertyArrayList props, DependencyMember member) throws InvalidDataException, ObjectNotFoundException {
        Logger.msg(5, "Dependency.convertToItemPropertyByScript() - Dependency:" + this.getName() + " memberUUID:" + member.getChildUUID());
        String scriptName = (String)member.getBuiltInProperty(BuiltInVertexProperties.SCRIPT_NAME);
        if (scriptName != null && scriptName.length() > 0) {
            PropertyArrayList newProps = (PropertyArrayList)member.evaluateScript();
            props.merge(newProps);
            return true;
        }
        return false;
    }

    public void addToVertexProperties(CastorHashMap props) throws InvalidDataException, ObjectNotFoundException {
        Logger.msg(2, "Dependency.addToVertexProperties(" + this.getName() + ") - Starting ...");
        BuiltInCollections builtInColl = BuiltInCollections.getValue(this.getName());
        block15: for (DependencyMember member : this.getMembers().list) {
            String memberUUID = member.getChildUUID();
            Integer memberVer = LocalObjectLoader.deriveVersionNumber(member.getBuiltInProperty(BuiltInVertexProperties.VERSION));
            if (memberVer == null) {
                throw new InvalidDataException("Version is null for Collection:" + this.getName() + ", DependencyMember:" + memberUUID);
            }
            if (this.convertToVertextPropsByScript(props, member) || builtInColl == null) continue;
            Logger.msg(5, "Dependency.addToVertexProperties() - Dependency:" + this.getName() + " memberUUID:" + memberUUID);
            switch (builtInColl) {
                case SCHEMA: {
                    String uuid;
                    try {
                        LocalObjectLoader.getSchema(memberUUID, memberVer);
                        props.setBuiltInProperty(BuiltInVertexProperties.SCHEMA_NAME, memberUUID);
                        props.setBuiltInProperty(BuiltInVertexProperties.SCHEMA_VERSION, memberVer);
                    }
                    catch (ObjectNotFoundException e) {
                        if (!props.containsKey((Object)BuiltInVertexProperties.SCHEMA_NAME)) continue block15;
                        Logger.msg(8, "Dependency.addToVertexProperties() - BACKWARD COMPABILITY: Dependency '" + this.getName() + "' is defined in Properties");
                        uuid = LocalObjectLoader.getSchema(props).getItemPath().getUUID().toString();
                        props.setBuiltInProperty(BuiltInVertexProperties.SCHEMA_NAME, uuid);
                    }
                    break;
                }
                case SCRIPT: {
                    String uuid;
                    try {
                        LocalObjectLoader.getScript(memberUUID, memberVer);
                        props.setBuiltInProperty(BuiltInVertexProperties.SCRIPT_NAME, memberUUID);
                        props.setBuiltInProperty(BuiltInVertexProperties.SCRIPT_VERSION, memberVer);
                    }
                    catch (ObjectNotFoundException e) {
                        if (!props.containsKey((Object)BuiltInVertexProperties.SCRIPT_NAME)) continue block15;
                        Logger.msg(8, "Dependency.addToVertexProperties() - BACKWARD COMPABILITY: Dependency '" + this.getName() + "' is defined in Properties");
                        uuid = LocalObjectLoader.getScript(props).getItemPath().getUUID().toString();
                        props.setBuiltInProperty(BuiltInVertexProperties.SCRIPT_NAME, uuid);
                    }
                    break;
                }
                case QUERY: {
                    String uuid;
                    try {
                        LocalObjectLoader.getQuery(memberUUID, memberVer);
                        props.setBuiltInProperty(BuiltInVertexProperties.QUERY_NAME, memberUUID);
                        props.setBuiltInProperty(BuiltInVertexProperties.QUERY_VERSION, memberVer);
                    }
                    catch (ObjectNotFoundException e) {
                        if (!props.containsKey((Object)BuiltInVertexProperties.QUERY_NAME)) continue block15;
                        Logger.msg(8, "Dependency.addToVertexProperties() - BACKWARD COMPABILITY: Dependency '" + this.getName() + "' is defined in Properties");
                        uuid = LocalObjectLoader.getQuery(props).getItemPath().getUUID().toString();
                        props.setBuiltInProperty(BuiltInVertexProperties.QUERY_NAME, uuid);
                    }
                    break;
                }
                case STATE_MACHINE: {
                    String uuid;
                    try {
                        LocalObjectLoader.getStateMachine(memberUUID, memberVer);
                        props.setBuiltInProperty(BuiltInVertexProperties.STATE_MACHINE_NAME, memberUUID);
                        props.setBuiltInProperty(BuiltInVertexProperties.STATE_MACHINE_VERSION, memberVer);
                    }
                    catch (ObjectNotFoundException e) {
                        if (!props.containsKey((Object)BuiltInVertexProperties.STATE_MACHINE_NAME)) continue block15;
                        Logger.msg(8, "Dependency.addToVertexProperties() -  BACKWARD COMPABILITY: Dependency '" + this.getName() + "' is defined in Properties");
                        uuid = LocalObjectLoader.getStateMachine(props).getItemPath().getUUID().toString();
                        props.setBuiltInProperty(BuiltInVertexProperties.STATE_MACHINE_NAME, uuid);
                    }
                    break;
                }
                case ACTIVITY: {
                    ActivityDef actDef = LocalObjectLoader.getActDef(memberUUID, memberVer);
                    CastorHashMap chm = null;
                    if (props.containsKey((Object)BuiltInVertexProperties.ACTIVITY_DEF_URN)) {
                        chm = (CastorHashMap)props.getBuiltInProperty(BuiltInVertexProperties.ACTIVITY_DEF_URN);
                    } else {
                        chm = new CastorHashMap();
                        props.setBuiltInProperty(BuiltInVertexProperties.ACTIVITY_DEF_URN, chm);
                    }
                    Logger.msg(8, "Dependency.addToVertexProperties(" + this.getName() + ") - actDef:" + actDef.getActName());
                    chm.put(actDef.getActName(), memberUUID + "~" + memberVer);
                    break;
                }
                default: {
                    Logger.msg(8, "Dependency.addToVertexProperties() - Cannot handle BuiltIn Dependency:" + this.getName());
                }
            }
        }
    }

    private boolean convertToVertextPropsByScript(CastorHashMap props, DependencyMember member) throws InvalidDataException, ObjectNotFoundException {
        Logger.msg(5, "Dependency.convertToVertextPropsByScript() - Dependency:" + this.getName() + " memberUUID:" + member.getChildUUID());
        String scriptName = (String)member.getBuiltInProperty(BuiltInVertexProperties.SCRIPT_NAME);
        if (scriptName != null && scriptName.length() > 0) {
            CastorHashMap newProps = (CastorHashMap)member.evaluateScript();
            props.merge(newProps);
            return true;
        }
        return false;
    }
}

