/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity;

import java.util.UUID;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.InvalidTransitionException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.common.SystemKey;
import org.cristalise.kernel.entity.ItemOperations;
import org.cristalise.kernel.entity.agent.JobArrayList;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.Workflow;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStepContainer;
import org.cristalise.kernel.lifecycle.instance.predefined.item.ItemPredefinedStepContainer;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.InvalidAgentPathException;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionManager;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Bootstrap;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;

public class ItemImplementation
implements ItemOperations {
    protected final TransactionManager mStorage = Gateway.getStorage();
    protected final ItemPath mItemPath;

    protected ItemImplementation(ItemPath key) {
        this.mItemPath = key;
    }

    @Override
    public SystemKey getSystemKey() {
        return this.mItemPath.getSystemKey();
    }

    public UUID getUUID() {
        return this.mItemPath.getUUID();
    }

    @Override
    public void initialise(SystemKey agentId, String propString, String initWfString, String initCollsString) throws AccessRightsException, InvalidDataException, PersistencyException {
        AgentPath agentPath;
        Logger.msg(5, "Item::initialise(" + this.mItemPath + ") - agent:" + agentId);
        Object locker = new Object();
        try {
            agentPath = new AgentPath(agentId);
        }
        catch (InvalidItemPathException e) {
            throw new AccessRightsException("Invalid Agent Id:" + agentId);
        }
        if (propString == null || propString.length() == 0 || propString.equals("<NULL/>")) {
            throw new InvalidDataException("No properties supplied");
        }
        try {
            PropertyArrayList props = (PropertyArrayList)Gateway.getMarshaller().unmarshall(propString);
            for (Property thisProp : props.list) {
                this.mStorage.put(this.mItemPath, thisProp, locker);
            }
        }
        catch (Throwable ex) {
            Logger.msg(8, "ItemImplementation::initialise(" + this.mItemPath + ") - Properties were invalid: " + propString);
            Logger.error(ex);
            this.mStorage.abort(locker);
            throw new InvalidDataException("Properties were invalid");
        }
        try {
            Schema initSchema = LocalObjectLoader.getSchema("ItemInitialization", 0);
            Outcome initOutcome = new Outcome(0, propString, initSchema);
            History hist = new History(this.mItemPath, locker);
            Event newEvent = hist.addEvent(new AgentPath(agentId), null, "", "Initialize", "", "", initSchema, Bootstrap.getPredefSM(), 0, "last");
            initOutcome.setID(newEvent.getID());
            Viewpoint newLastView = new Viewpoint(this.mItemPath, initSchema, "last", newEvent.getID());
            Gateway.getStorage().put(this.mItemPath, initOutcome, locker);
            Gateway.getStorage().put(this.mItemPath, newLastView, locker);
        }
        catch (Throwable ex) {
            Logger.msg(8, "ItemImplementation::initialise(" + this.mItemPath + ") - Could not store event and outcome.");
            Logger.error(ex);
            this.mStorage.abort(locker);
            throw new PersistencyException("Error storing event and outcome");
        }
        if (initCollsString != null && initCollsString.length() > 0 && !initCollsString.equals("<NULL/>")) {
            try {
                CollectionArrayList colls = (CollectionArrayList)Gateway.getMarshaller().unmarshall(initCollsString);
                for (Collection thisColl : colls.list) {
                    this.mStorage.put(this.mItemPath, thisColl, locker);
                }
            }
            catch (Throwable ex) {
                Logger.msg(8, "ItemImplementation::initialise(" + this.mItemPath + ") - Collections were invalid: " + initCollsString);
                Logger.error(ex);
                this.mStorage.abort(locker);
                throw new InvalidDataException("Collections were invalid");
            }
        }
        Workflow lc = null;
        try {
            lc = initWfString == null || initWfString.length() == 0 || initWfString.equals("<NULL/>") ? new Workflow(new CompositeActivity(), this.getNewPredefStepContainer()) : new Workflow((CompositeActivity)Gateway.getMarshaller().unmarshall(initWfString), this.getNewPredefStepContainer());
            this.mStorage.put(this.mItemPath, lc, locker);
        }
        catch (Throwable ex) {
            Logger.msg(8, "ItemImplementation::initialise(" + this.mItemPath + ") - Workflow was invalid: " + initWfString);
            Logger.error(ex);
            this.mStorage.abort(locker);
            throw new InvalidDataException("Workflow was invalid");
        }
        lc.initialise(this.mItemPath, agentPath, locker);
        this.mStorage.put(this.mItemPath, lc, locker);
        this.mStorage.commit(locker);
        Logger.msg(3, "Initialisation of item " + this.mItemPath + " was successful");
    }

    protected PredefinedStepContainer getNewPredefStepContainer() {
        return new ItemPredefinedStepContainer();
    }

    @Override
    public String requestAction(SystemKey agentId, String stepPath, int transitionID, String requestData) throws AccessRightsException, InvalidTransitionException, ObjectNotFoundException, InvalidDataException, PersistencyException, ObjectAlreadyExistsException, InvalidCollectionModification {
        return this.delegatedAction(agentId, null, stepPath, transitionID, requestData);
    }

    @Override
    public String delegatedAction(SystemKey agentId, SystemKey delegateId, String stepPath, int transitionID, String requestData) throws AccessRightsException, InvalidTransitionException, ObjectNotFoundException, InvalidDataException, PersistencyException, ObjectAlreadyExistsException, InvalidCollectionModification {
        try {
            AgentPath agent = new AgentPath(agentId);
            AgentPath delegate = null;
            if (delegateId != null) {
                delegate = new AgentPath(delegateId);
            }
            Logger.msg(1, "ItemImplementation::request(" + this.mItemPath + ") - Transition " + transitionID + " on " + stepPath + " by " + (delegate == null ? "" : delegate + " on behalf of ") + agent);
            Workflow lifeCycle = (Workflow)this.mStorage.get(this.mItemPath, "LifeCycle/workflow", null);
            String finalOutcome = lifeCycle.requestAction(agent, delegate, stepPath, this.mItemPath, transitionID, requestData);
            if (!stepPath.startsWith("workflow/predefined")) {
                this.mStorage.put(this.mItemPath, lifeCycle, null);
            }
            if (stepPath.equals("workflow/predefined/Erase")) {
                Logger.msg("Erasing item path " + this.mItemPath.toString());
                Gateway.getLookupManager().delete(this.mItemPath);
            }
            return finalOutcome;
        }
        catch (AccessRightsException | InvalidCollectionModification | InvalidDataException | InvalidTransitionException | ObjectAlreadyExistsException | ObjectNotFoundException ex) {
            if (Logger.doLog(8)) {
                Logger.error((Throwable)ex);
            }
            throw ex;
        }
        catch (CannotManageException | ObjectCannotBeUpdated | InvalidAgentPathException ex) {
            if (Logger.doLog(8)) {
                Logger.error((Throwable)ex);
            }
            throw new InvalidDataException(ex.getClass().getName() + " - " + ((Throwable)ex).getMessage());
        }
        catch (Throwable ex) {
            Logger.error("Unknown Error: requestAction on " + this.mItemPath + " by " + agentId + " executing " + stepPath);
            Logger.error(ex);
            throw new InvalidDataException("Extraordinary Exception during execution:" + ex.getClass().getName() + " - " + ex.getMessage());
        }
    }

    @Override
    public String queryLifeCycle(SystemKey agentId, boolean filter) throws AccessRightsException, ObjectNotFoundException, PersistencyException {
        Logger.msg(1, "ItemImplementation::queryLifeCycle(" + this.mItemPath + ") - agent: " + agentId);
        try {
            AgentPath agent;
            try {
                agent = new AgentPath(agentId);
            }
            catch (InvalidItemPathException e) {
                throw new AccessRightsException("Agent " + agentId + " doesn't exist");
            }
            Workflow wf = (Workflow)this.mStorage.get(this.mItemPath, "LifeCycle/workflow", null);
            JobArrayList jobBag = new JobArrayList();
            CompositeActivity domainWf = (CompositeActivity)wf.search("workflow/domain");
            jobBag.list = filter ? domainWf.calculateJobs(agent, this.mItemPath, true) : domainWf.calculateAllJobs(agent, this.mItemPath, true);
            Logger.msg(1, "ItemImplementation::queryLifeCycle(" + this.mItemPath + ") - Returning " + jobBag.list.size() + " jobs.");
            try {
                return Gateway.getMarshaller().marshall(jobBag);
            }
            catch (Exception e) {
                Logger.error(e);
                throw new PersistencyException("Error marshalling job bag");
            }
        }
        catch (Throwable ex) {
            Logger.error("ItemImplementation::queryLifeCycle(" + this.mItemPath + ") - Unknown error");
            Logger.error(ex);
            throw new PersistencyException("Unknown error querying jobs. Please see server log.");
        }
    }

    @Override
    public String queryData(String path) throws AccessRightsException, ObjectNotFoundException, PersistencyException {
        String result = "";
        Logger.msg(1, "ItemImplementation::queryData(" + this.mItemPath + ") - " + path);
        try {
            if (path.endsWith("/all")) {
                int allPos = path.lastIndexOf("all");
                String query = path.substring(0, allPos);
                String[] ids = this.mStorage.getClusterContents(this.mItemPath, query);
                for (int i = 0; i < ids.length; ++i) {
                    result = result + ids[i];
                    if (i == ids.length - 1) continue;
                    result = result + ",";
                }
            } else {
                result = Gateway.getMarshaller().marshall(this.mStorage.get(this.mItemPath, path, null));
            }
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            Logger.warning("ItemImplementation::queryData(" + this.mItemPath + ") - " + path + " Failed: " + ex.getClass().getName());
            throw new PersistencyException("Server exception: " + ex.getClass().getName());
        }
        if (Logger.doLog(9)) {
            Logger.msg(9, "ItemImplementation::queryData(" + this.mItemPath + ") - result:" + result);
        }
        return result;
    }

    protected void finalize() throws Throwable {
        Logger.msg(7, "ItemImplementation.finalize() - Reaping " + this.mItemPath);
        Gateway.getStorage().clearCache(this.mItemPath, null);
        super.finalize();
    }
}

