/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.proxy;

import java.io.IOException;
import java.net.DatagramPacket;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;

public class ProxyMessage {
    public static final String BYEPATH = "bye";
    public static final String ADDPATH = "add";
    public static final String DELPATH = "del";
    public static final String PINGPATH = "ping";
    public static final boolean ADDED = false;
    public static final boolean DELETED = true;
    static ProxyMessage byeMessage = new ProxyMessage(null, "bye", false);
    static ProxyMessage pingMessage = new ProxyMessage(null, "ping", false);
    private ItemPath itemPath = null;
    private String path = "";
    private String server = null;
    private boolean state = false;

    public ProxyMessage() {
    }

    public ProxyMessage(ItemPath itemPath, String path, boolean state) {
        this();
        this.setItemPath(itemPath);
        this.setPath(path);
        this.setState(state);
    }

    public ProxyMessage(String line) throws InvalidDataException, IOException {
        if (line == null) {
            throw new IOException("Null proxy message");
        }
        String[] tok = line.split(":");
        if (tok.length != 2) {
            throw new InvalidDataException("String '" + line + "' does not constitute a valid proxy message.");
        }
        if (tok[0].length() > 0 && !tok[0].equals("tree")) {
            try {
                this.itemPath = new ItemPath(tok[0]);
            }
            catch (InvalidItemPathException e) {
                throw new InvalidDataException("Item in proxy message " + line + " was not valid");
            }
        }
        this.path = tok[1];
        if (this.path.startsWith("-")) {
            this.state = true;
            this.path = this.path.substring(1);
        }
    }

    public ProxyMessage(DatagramPacket packet) throws InvalidDataException, IOException {
        this(new String(packet.getData()));
    }

    public ItemPath getItemPath() {
        return this.itemPath;
    }

    public void setItemPath(ItemPath itemPath) {
        this.itemPath = itemPath;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String newPath) {
        this.path = newPath;
    }

    public boolean getState() {
        return this.state;
    }

    public void setState(boolean state) {
        this.state = state;
    }

    public String toString() {
        return (this.itemPath == null ? "tree" : this.itemPath.getUUID()) + ":" + (this.state ? "-" : "") + this.path;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }
}

