/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.proxy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.Socket;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.entity.proxy.ProxyManager;
import org.cristalise.kernel.entity.proxy.ProxyMessage;
import org.cristalise.kernel.utils.Logger;

public class ProxyServerConnection
extends Thread {
    public boolean serverIsActive = true;
    String serverName;
    int serverPort;
    Socket serverConnection;
    ProxyManager manager;
    PrintWriter serverStream;
    boolean listening = false;
    static boolean isServer = false;

    public ProxyServerConnection(String host, int port, ProxyManager manager) {
        Logger.msg(5, "ProxyServerConnection - Initialising connection to " + host + ":" + port);
        this.serverName = host;
        this.serverPort = port;
        this.manager = manager;
        this.listening = true;
        this.start();
    }

    @Override
    public void run() {
        Thread.currentThread().setName("Proxy Client Connection Listener to " + this.serverName + ":" + this.serverPort);
        while (this.listening) {
            try {
                if (this.serverConnection == null) {
                    this.connect();
                }
                if (this.serverConnection == null) continue;
                BufferedReader request = new BufferedReader(new InputStreamReader(this.serverConnection.getInputStream()));
                String input = null;
                while (this.listening && this.serverConnection != null) {
                    try {
                        input = request.readLine();
                        ProxyMessage thisMessage = new ProxyMessage(input);
                        thisMessage.setServer(this.serverName);
                        this.manager.processMessage(thisMessage);
                    }
                    catch (InterruptedIOException ex) {
                        this.sendMessage(ProxyMessage.pingMessage);
                    }
                    catch (InvalidDataException ex) {
                        if (input == null) continue;
                        Logger.error("ProxyManager - Invalid proxy message: " + input);
                    }
                }
            }
            catch (IOException ex) {
                Logger.error("ProxyServerConnection - Disconnected from " + this.serverName + ":" + this.serverPort);
                try {
                    this.serverStream.close();
                    this.serverConnection.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.serverStream = null;
                this.serverConnection = null;
            }
        }
        if (this.serverStream != null) {
            try {
                Logger.msg(1, "Disconnecting from proxy server on " + this.serverName + ":" + this.serverPort);
                this.serverStream.println(ProxyMessage.byeMessage.toString());
                this.serverStream.close();
                this.serverConnection.close();
                this.serverConnection = null;
            }
            catch (Exception e) {
                Logger.error("Error disconnecting from proxy server.");
            }
        }
    }

    public void connect() {
        Logger.msg(3, "ProxyServerConnection - connecting to proxy server on " + this.serverName + ":" + this.serverPort);
        try {
            this.serverConnection = new Socket(this.serverName, this.serverPort);
            this.serverConnection.setKeepAlive(true);
            this.serverIsActive = true;
            this.serverConnection.setSoTimeout(5000);
            this.serverStream = new PrintWriter(this.serverConnection.getOutputStream(), true);
            Logger.msg("Connected to proxy server on " + this.serverName + ":" + this.serverPort);
            this.manager.resubscribe(this);
        }
        catch (Exception e) {
            Logger.msg(3, "Could not connect to proxy server. Retrying in 5s");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.serverStream = null;
            this.serverConnection = null;
            this.serverIsActive = false;
        }
    }

    public void shutdown() {
        Logger.msg("Proxy Client: flagging shutdown.");
        this.listening = false;
        if (this.serverConnection != null) {
            try {
                this.serverConnection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void sendMessage(ProxyMessage sub) {
        if (this.serverStream != null) {
            this.serverStream.println(sub);
        }
    }
}

