/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.graph.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import java.util.Stack;
import org.cristalise.kernel.graph.event.EntireModelChangedEvent;
import org.cristalise.kernel.graph.event.ForcedNotifyEvent;
import org.cristalise.kernel.graph.event.GraphModelEvent;
import org.cristalise.kernel.graph.model.EdgeFactory;
import org.cristalise.kernel.graph.model.GraphModel;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.graph.model.VertexFactory;
import org.cristalise.kernel.graph.model.VertexOutlineCreator;
import org.cristalise.kernel.utils.Logger;

public class GraphModelManager
extends Observable {
    private GraphModel mGraphModel;
    private EdgeFactory mEdgeFactory;
    private VertexFactory mVertexFactory;
    private VertexOutlineCreator mVertexOutlineCreator;
    private final EntireModelChangedEvent mEntireModelChangedEvent = new EntireModelChangedEvent();
    private final ForcedNotifyEvent mForcedNotifyEvent = new ForcedNotifyEvent();
    private final Stack<GraphModel> mParentModels = new Stack();
    private final ArrayList<Integer> mParentIds = new ArrayList();
    private boolean mEditable = true;

    public GraphModelManager() {
        this.mGraphModel = new GraphModel();
        this.mGraphModel.setManager(this);
    }

    public GraphModelManager(GraphModel newModel) {
        newModel.setManager(this);
        this.mGraphModel = newModel;
    }

    public void replace(GraphModel newModel) {
        this.mParentModels.clear();
        Iterator<Integer> iter = this.mParentIds.iterator();
        while (iter.hasNext()) {
            Integer parentId = iter.next();
            GraphableVertex childModelVertex = (GraphableVertex)newModel.getVertexById(parentId);
            if (childModelVertex == null) {
                Logger.msg(7, "Didn't find " + parentId + " in new model tree. Stopping here.");
                do {
                    iter.remove();
                } while (iter.hasNext());
                break;
            }
            this.mParentModels.push(newModel);
            Logger.msg(7, "Pushing model and switching to " + parentId);
            newModel = childModelVertex.getChildrenGraphModel();
        }
        this.setModel(newModel);
    }

    public void setModel(GraphModel newModel) {
        newModel.mNewEdgeOriginVertex = null;
        newModel.mNewEdgeEndPoint = null;
        newModel.setExternalEdgeFactory(this.mEdgeFactory);
        newModel.setExternalVertexFactory(this.mVertexFactory);
        newModel.setVertexOutlineCreator(this.mVertexOutlineCreator);
        this.mVertexFactory.setCreationContext(newModel.getContainingVertex());
        newModel.setManager(this);
        this.mGraphModel.setManager(null);
        this.mGraphModel = newModel;
        this.notifyObservers(this.mEntireModelChangedEvent);
    }

    public void zoomIn(Vertex child) {
        GraphModel childModel = child.getChildrenGraphModel();
        if (childModel != null) {
            this.mParentModels.push(this.mGraphModel);
            this.mParentIds.add(child.getID());
            this.setModel(childModel);
            Logger.msg(7, "ZoomIn - Stack size: " + this.mParentModels.size() + " ids:" + this.mParentIds.size());
        }
    }

    public void zoomOut() {
        if (!this.mParentModels.empty()) {
            this.setModel(this.mParentModels.pop());
            this.mParentIds.remove(this.mParentIds.size() - 1);
        }
        Logger.msg(7, "ZoomOut - Stack size: " + this.mParentModels.size() + " ids:" + this.mParentIds.size());
    }

    public void forceNotify() {
        this.notifyObservers(this.mForcedNotifyEvent);
    }

    public GraphModel getModel() {
        return this.mGraphModel;
    }

    public void setExternalEdgeFactory(EdgeFactory newEdgeFactory) {
        this.mEdgeFactory = newEdgeFactory;
        this.mGraphModel.setExternalEdgeFactory(newEdgeFactory);
    }

    public void setExternalVertexFactory(VertexFactory newVertexFactory) {
        this.mVertexFactory = newVertexFactory;
        this.mGraphModel.setExternalVertexFactory(newVertexFactory);
    }

    public void setVertexOutlineCreator(VertexOutlineCreator newVertexOutlineCreator) {
        this.mVertexOutlineCreator = newVertexOutlineCreator;
        this.mGraphModel.setVertexOutlineCreator(newVertexOutlineCreator);
    }

    public void notifyObservers(GraphModelEvent ev) {
        this.setChanged();
        super.notifyObservers(ev);
    }

    public void setEditable(boolean editable) {
        this.mEditable = editable;
    }

    public boolean isEditable() {
        return this.mEditable;
    }
}

