/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.graph.model;

import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.graph.model.DirectedEdge;
import org.cristalise.kernel.graph.model.GraphModel;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.model.GraphableEdge;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.KeyValuePair;
import org.cristalise.kernel.utils.Logger;

public abstract class GraphableVertex
extends Vertex {
    private CastorHashMap mProperties = new CastorHashMap();
    private boolean mIsLayoutable;
    protected boolean mIsComposite;
    private GraphModel mChildrenGraphModel;
    private GraphableVertex parent;

    public void setProperties(CastorHashMap props) {
        this.mProperties = props;
    }

    public CastorHashMap getProperties() {
        return this.mProperties;
    }

    protected Integer deriveVersionNumber(Object val) throws InvalidDataException {
        if (val == null || val.equals("") || val.toString().equals("-1")) {
            return null;
        }
        try {
            return Integer.valueOf(val.toString());
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException("Invalid version number : " + val.toString());
        }
    }

    public KeyValuePair[] getKeyValuePairs() {
        return this.mProperties.getKeyValuePairs();
    }

    public void setKeyValuePairs(KeyValuePair[] pairs) {
        this.mProperties.setKeyValuePairs(pairs);
    }

    public GraphableVertex getParent() {
        return this.parent;
    }

    public void setParent(GraphableVertex parent) {
        if (this.equals(parent)) {
            throw new ExceptionInInitializerError();
        }
        this.parent = parent;
    }

    @Override
    public GraphModel getChildrenGraphModel() {
        return this.mChildrenGraphModel;
    }

    @Override
    public Object getCreationContext() {
        return this;
    }

    public Vertex[] getOutGraphables() {
        if (this.parent == null) {
            return new Vertex[0];
        }
        return this.parent.mChildrenGraphModel.getOutVertices(this);
    }

    public DirectedEdge[] getOutEdges() {
        if (this.parent == null) {
            return new DirectedEdge[0];
        }
        return this.parent.mChildrenGraphModel.getOutEdges(this);
    }

    public DirectedEdge[] getInEdges() {
        if (this.parent == null) {
            return new DirectedEdge[0];
        }
        DirectedEdge[] edges = this.getParent().mChildrenGraphModel.getInEdges(this);
        if (edges != null) {
            return edges;
        }
        return new DirectedEdge[0];
    }

    public GraphableVertex[] getChildren() {
        return this.getLayoutableChildren();
    }

    public DirectedEdge[] getChildrenEdges() {
        if (this.getIsComposite()) {
            return this.getChildrenGraphModel().getEdges();
        }
        return null;
    }

    public GraphableVertex[] getLayoutableChildren() {
        if (this.getIsComposite() && this.mChildrenGraphModel != null) {
            Vertex[] vs = this.mChildrenGraphModel.getVertices();
            GraphableVertex[] gvs = new GraphableVertex[vs.length];
            for (int i = 0; i < vs.length; ++i) {
                gvs[i] = (GraphableVertex)vs[i];
            }
            return gvs;
        }
        return null;
    }

    public GraphableVertex search(String ids) {
        if (this.getName().equals(ids)) {
            return this;
        }
        if (String.valueOf(this.getID()).equals(ids)) {
            return this;
        }
        if (this.getIsComposite()) {
            GraphableVertex[] graphables = this.getChildren();
            if (ids.startsWith(String.valueOf(this.getID()))) {
                ids = ids.substring(ids.indexOf("/") + 1);
            } else if (ids.startsWith(this.getName())) {
                ids = ids.substring(this.getName().length() + 1);
            } else if (ids.startsWith(this.getPath())) {
                ids = ids.substring(this.getPath().length() + 1);
            } else {
                return null;
            }
            for (GraphableVertex graphable : graphables) {
                GraphableVertex grap = graphable.search(ids);
                if (grap == null) continue;
                return grap;
            }
        }
        return null;
    }

    public boolean getIsLayoutable() {
        return this.mIsLayoutable;
    }

    public void setIsLayoutable(boolean isLayoutable) {
        this.mIsLayoutable = isLayoutable;
    }

    public boolean getIsComposite() {
        return this.mIsComposite;
    }

    public void setIsComposite(boolean isComposite) {
        this.mIsComposite = isComposite;
    }

    public void addChild(GraphableVertex graphableVertex, GraphPoint g) {
        this.getChildrenGraphModel().addVertexAndCreateId(graphableVertex, g);
        graphableVertex.setParent(this);
    }

    public void setChildrenGraphModel(GraphModel childrenGraph) throws InvalidDataException {
        this.mChildrenGraphModel = childrenGraph;
        DirectedEdge[] edges = this.mChildrenGraphModel.getEdges();
        GraphableVertex[] graphables = this.getLayoutableChildren();
        if (graphables != null) {
            for (GraphableVertex graphable : graphables) {
                graphable.setParent(this);
            }
        }
        if (edges != null) {
            for (DirectedEdge edge : edges) {
                ((GraphableEdge)edge).setParent(this);
            }
        }
        childrenGraph.setContainingVertex(this);
    }

    @Override
    public GraphPoint getCentrePoint() {
        if (!this.getIsLayoutable()) {
            return null;
        }
        return super.getCentrePoint();
    }

    @Override
    public int[] getInEdgeIds() {
        if (!this.getIsLayoutable()) {
            return null;
        }
        return super.getInEdgeIds();
    }

    @Override
    public int[] getOutEdgeIds() {
        if (!this.getIsLayoutable()) {
            return null;
        }
        return super.getOutEdgeIds();
    }

    @Override
    public GraphPoint[] getOutlinePoints() {
        if (!this.getIsLayoutable()) {
            return null;
        }
        return super.getOutlinePoints();
    }

    public String getPath() {
        if (this.getName() != null && !this.getName().equals("")) {
            return this.getParent().getPath() + "/" + this.getName();
        }
        return this.getParent().getPath() + "/" + this.getID();
    }

    public Object getBuiltInProperty(BuiltInVertexProperties prop) {
        return this.mProperties.get(prop.getName());
    }

    public void setBuiltInProperty(BuiltInVertexProperties prop, Object val) {
        this.mProperties.put(prop.getName(), val);
    }

    public void updatePropertiesFromCollection(BuiltInVertexProperties vertexProp, CastorHashMap newProps) throws InvalidDataException {
        switch (vertexProp) {
            case ACTIVITY_DEF_URN: {
                if (!(this instanceof Activity)) break;
                Object value = null;
                Activity thisAct = (Activity)this;
                if (newProps.containsKey(thisAct.getID())) {
                    value = newProps.get(thisAct.getID());
                } else if (newProps.containsKey(thisAct.getTypeName())) {
                    value = newProps.get(thisAct.getTypeName());
                }
                if (value != null) {
                    Logger.msg(5, "GraphableVertex.updatePropertiesFromCollection(" + (Object)((Object)vertexProp) + ") - UPDATING typeName:" + thisAct.getTypeName() + " id:" + thisAct.getID());
                    this.mProperties.setBuiltInProperty(BuiltInVertexProperties.ACTIVITY_DEF_URN, value);
                    break;
                }
                Logger.msg(5, "GraphableVertex.updatePropertiesFromCollection(" + (Object)((Object)vertexProp) + ") - SKIPPING typeName:" + thisAct.getTypeName() + " id:" + thisAct.getID());
                break;
            }
            default: {
                throw new InvalidDataException("Cannot handle BuiltInVertexProperty:" + (Object)((Object)vertexProp));
            }
        }
    }

    public void updatePropertiesFromCollection(int slotID, CastorHashMap newProps) throws InvalidDataException {
        if (this.getID() == slotID) {
            Logger.msg(5, "GraphableVertex.updatePropertiesFromCollection(slotID:" + slotID + ") - MERGING properties for name:" + this.getName() + " id:" + this.getID());
            newProps.dump(5);
            this.mProperties.merge(newProps);
        } else {
            Logger.msg(5, "GraphableVertex.updatePropertiesFromCollection(slotID:" + slotID + ") - SKIPPING name:" + this.getName() + " id:" + this.getID());
        }
    }
}

