/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.graph.traversal;

import java.util.Vector;
import org.cristalise.kernel.graph.model.GraphModel;
import org.cristalise.kernel.graph.model.Vertex;

public class GraphTraversal {
    public static final int kUp = 1;
    public static final int kDown = 2;

    private GraphTraversal() {
    }

    public static Vertex[] getTraversal(GraphModel graphModel, Vertex startVertex, int direction, boolean ignoreBackLinks) {
        Vector<Vertex> path = new Vector<Vertex>(10, 10);
        graphModel.clearTags(startVertex);
        GraphTraversal.visitVertex(startVertex, graphModel, path, direction, startVertex, ignoreBackLinks);
        return path.toArray(new Vertex[path.size()]);
    }

    private static void visitVertex(Vertex vertex, GraphModel graphModel, Vector<Vertex> path, int direction, Object tag, boolean ignoreBackLinks) {
        Vertex[] children = null;
        int i = 0;
        children = direction == 2 ? graphModel.getOutVertices(vertex) : graphModel.getInVertices(vertex);
        vertex.setTag(tag);
        path.add(vertex);
        for (i = 0; i < children.length; ++i) {
            if (children[i].hasTag(tag)) continue;
            boolean skipBackLink = false;
            if (ignoreBackLinks && (vertex.isJoin() && direction == 1 || vertex.isLoop() && direction == 2)) {
                Vertex[] following;
                for (Vertex element : following = GraphTraversal.getTraversal(graphModel, children[i], direction, false)) {
                    if (element != vertex) continue;
                    skipBackLink = true;
                    break;
                }
            }
            if (skipBackLink) continue;
            GraphTraversal.visitVertex(children[i], graphModel, path, direction, tag, ignoreBackLinks);
        }
    }
}

