/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Vector;
import org.cristalise.kernel.collection.BuiltInCollections;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.collection.DependencyMember;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.WfCastorHashMap;
import org.cristalise.kernel.lifecycle.WfVertexDef;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lifecycle.instance.WfVertex;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.querying.Query;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.utils.DescriptionObject;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;

public class ActivityDef
extends WfVertexDef
implements C2KLocalObject,
DescriptionObject {
    private Integer mVersion = null;
    public boolean changed = false;
    ItemPath itemPath;
    Schema actSchema;
    Script actScript;
    Query actQuery;
    StateMachine actStateMachine;

    public ActivityDef() {
        this.mErrors = new Vector(0, 1);
        this.setProperties(new WfCastorHashMap());
        this.setIsLayoutable(false);
    }

    @Override
    public void setID(int id) {
        super.setID(id);
        if (this.getName() == null || "".equals(this.getName())) {
            this.setName(String.valueOf(id));
        }
    }

    @Override
    public String getItemID() {
        return this.itemPath != null ? this.itemPath.getUUID().toString() : null;
    }

    @Override
    public void setVersion(Integer v) {
        this.mVersion = v;
    }

    @Override
    public Integer getVersion() {
        return this.mVersion;
    }

    @Override
    public String getErrors() {
        return super.getErrors();
    }

    @Override
    public boolean verify() {
        return true;
    }

    @Override
    public String getClusterType() {
        return null;
    }

    @Override
    public String getClusterPath() {
        return null;
    }

    public String getActName() {
        return this.getName();
    }

    public String getDescName() {
        return this.getName();
    }

    @Override
    public WfVertex instantiate() throws ObjectNotFoundException, InvalidDataException {
        return this.instantiate(this.getName());
    }

    public WfVertex instantiate(String name) throws ObjectNotFoundException, InvalidDataException {
        Activity act = new Activity();
        act.setName(name);
        this.configureInstance(act);
        if (this.getItemPath() != null) {
            act.setType(this.getItemID());
        }
        return act;
    }

    @Override
    public void configureInstance(WfVertex act) throws InvalidDataException, ObjectNotFoundException {
        super.configureInstance(act);
        try {
            for (String collName : Gateway.getStorage().getClusterContents(this.itemPath, "Collection")) {
                Logger.msg(5, "ActivityDef.configureInstance(" + this.getName() + ") - Processing collection:" + collName);
                String verStr = this.mVersion == null || this.mVersion == -1 ? "last" : String.valueOf(this.mVersion);
                Dependency dep = null;
                try {
                    dep = (Dependency)Gateway.getStorage().get(this.itemPath, "Collection/" + collName + "/" + verStr, null);
                }
                catch (ObjectNotFoundException e) {
                    if (Logger.doLog(8)) {
                        Logger.warning("Unavailable Collection path:" + this.itemPath + "/" + "Collection" + "/" + collName + "/" + verStr);
                    }
                }
                catch (PersistencyException e) {
                    Logger.error((Throwable)((Object)e));
                    throw new InvalidDataException("Collection:" + collName + " error:" + e.getMessage());
                }
                if (dep == null) continue;
                dep.addToVertexProperties(act.getProperties());
            }
        }
        catch (PersistencyException e) {
            Logger.error((Throwable)((Object)e));
            throw new InvalidDataException(e.getMessage());
        }
    }

    @Override
    public ItemPath getItemPath() {
        return this.itemPath;
    }

    @Override
    public void setItemPath(ItemPath path) {
        this.itemPath = path;
    }

    public Schema getSchema() throws InvalidDataException, ObjectNotFoundException {
        if (this.actSchema == null) {
            Logger.msg(1, "ActivityDef.getSchema(actName:" + this.getName() + ") - Loading ...");
            this.actSchema = LocalObjectLoader.getSchema(this.getProperties());
        }
        return this.actSchema;
    }

    public Script getScript() throws InvalidDataException, ObjectNotFoundException {
        if (this.actScript == null) {
            Logger.msg(1, "ActivityDef.getScript(actName:" + this.getName() + ") - Loading ...");
            this.actScript = LocalObjectLoader.getScript(this.getProperties());
        }
        return this.actScript;
    }

    public Query getQuery() throws InvalidDataException, ObjectNotFoundException {
        if (this.actQuery == null) {
            Logger.msg(1, "ActivityDef.getQuery(actName:" + this.getName() + ") - Loading ...");
            this.actQuery = LocalObjectLoader.getQuery(this.getProperties());
        }
        return this.actQuery;
    }

    public StateMachine getStateMachine() throws InvalidDataException, ObjectNotFoundException {
        if (this.actStateMachine == null) {
            Logger.msg(1, "ActivityDef.getStateMachine(actName:" + this.getName() + ") - Loading ...");
            this.actStateMachine = LocalObjectLoader.getStateMachine(this.getProperties());
        }
        return this.actStateMachine;
    }

    @Deprecated
    protected DescriptionObject[] getBuiltInCollectionResource(BuiltInCollections collection) throws ObjectNotFoundException, InvalidDataException {
        Dependency resColl;
        if (this.itemPath == null) {
            throw new ObjectNotFoundException();
        }
        Logger.msg(5, "ActivityDef.getCollectionResource(actName:" + this.getName() + ") - Loading from collection:" + (Object)((Object)collection));
        try {
            String verStr = this.mVersion == null || this.mVersion == -1 ? "last" : String.valueOf(this.mVersion);
            resColl = (Dependency)Gateway.getStorage().get(this.itemPath, "Collection/" + (Object)((Object)collection) + "/" + verStr, null);
        }
        catch (PersistencyException e) {
            Logger.error((Throwable)((Object)e));
            throw new InvalidDataException("Error loading description collection " + (Object)((Object)collection));
        }
        ArrayList<DescriptionObject> retArr = new ArrayList<DescriptionObject>();
        block9: for (DependencyMember resMem : resColl.getMembers().list) {
            String resUUID = resMem.getChildUUID();
            Integer resVer = this.deriveVersionNumber(resMem.getBuiltInProperty(BuiltInVertexProperties.VERSION));
            if (resVer == null) {
                throw new InvalidDataException("Version is null for Item:" + this.itemPath + ", Collection:" + (Object)((Object)collection) + ", DependencyMember:" + resUUID);
            }
            switch (collection) {
                case SCHEMA: {
                    retArr.add(LocalObjectLoader.getSchema(resUUID, resVer));
                    continue block9;
                }
                case SCRIPT: {
                    retArr.add(LocalObjectLoader.getScript(resUUID, resVer));
                    continue block9;
                }
                case QUERY: {
                    retArr.add(LocalObjectLoader.getQuery(resUUID, resVer));
                    continue block9;
                }
                case STATE_MACHINE: {
                    retArr.add(LocalObjectLoader.getStateMachine(resUUID, resVer));
                    continue block9;
                }
                case ACTIVITY: {
                    retArr.add(LocalObjectLoader.getActDef(resUUID, resVer));
                    continue block9;
                }
            }
            throw new InvalidDataException("");
        }
        if (retArr.size() == 0) {
            throw new ObjectNotFoundException();
        }
        return retArr.toArray(new DescriptionObject[retArr.size()]);
    }

    public void setSchema(Schema actSchema) {
        this.actSchema = actSchema;
    }

    public void setScript(Script actScript) {
        this.actScript = actScript;
    }

    public void setQuery(Query actQuery) {
        this.actQuery = actQuery;
    }

    public void setStateMachine(StateMachine actStateMachine) {
        this.actStateMachine = actStateMachine;
    }

    public Dependency makeDescCollection(BuiltInCollections collection, DescriptionObject ... descs) throws InvalidDataException {
        Dependency descDep = new Dependency(collection.getName());
        if (this.mVersion != null && this.mVersion > -1) {
            descDep.setVersion(this.mVersion);
        }
        for (DescriptionObject thisDesc : descs) {
            if (thisDesc == null) continue;
            try {
                DependencyMember descMem = descDep.addMember(thisDesc.getItemPath());
                descMem.setBuiltInProperty(BuiltInVertexProperties.VERSION, thisDesc.getVersion());
            }
            catch (Exception e) {
                Logger.error(e);
                throw new InvalidDataException("Problem creating description collection for " + thisDesc + " in " + this.getName());
            }
        }
        return descDep;
    }

    @Override
    public CollectionArrayList makeDescCollections() throws InvalidDataException, ObjectNotFoundException {
        CollectionArrayList retArr = new CollectionArrayList();
        retArr.put(this.makeDescCollection(BuiltInCollections.SCHEMA, this.getSchema()));
        retArr.put(this.makeDescCollection(BuiltInCollections.SCRIPT, this.getScript()));
        retArr.put(this.makeDescCollection(BuiltInCollections.QUERY, this.getQuery()));
        retArr.put(this.makeDescCollection(BuiltInCollections.STATE_MACHINE, this.getStateMachine()));
        return retArr;
    }

    @Override
    public void export(Writer imports, File dir) throws InvalidDataException, ObjectNotFoundException, IOException {
        String actXML;
        String tc = BuiltInResources.ELEM_ACT_DESC_RESOURCE.getTypeCode();
        try {
            actXML = Gateway.getMarshaller().marshall(this);
        }
        catch (Exception e) {
            Logger.error(e);
            throw new InvalidDataException("Couldn't marshall activity def " + this.getActName());
        }
        FileStringUtility.string2File(new File(new File(dir, tc), this.getActName() + (this.getVersion() == null ? "" : "_" + this.getVersion()) + ".xml"), actXML);
        if (imports != null) {
            imports.write("<Activity " + this.getExportAttributes(tc) + ">" + this.getExportCollections() + "</Activity>\n");
        }
    }

    protected String getExportAttributes(String type) throws InvalidDataException, ObjectNotFoundException, IOException {
        return "name=\"" + this.getActName() + "\" " + (this.getItemPath() == null ? "" : "id=\"" + this.getItemID() + "\" ") + (this.getVersion() == null ? "" : "version=\"" + this.getVersion() + "\" ") + "resource=\"boot/" + type + "/" + this.getActName() + (this.getVersion() == null ? "" : "_" + this.getVersion()) + ".xml\"";
    }

    protected String getExportCollections() throws InvalidDataException, ObjectNotFoundException, IOException {
        return (this.getStateMachine() == null ? "" : "<StateMachine name=\"" + this.getStateMachine().getName() + "\" id=\"" + this.getStateMachine().getItemID() + "\" version=\"" + this.getStateMachine().getVersion() + "\"/>") + (this.getSchema() == null ? "" : "<Schema       name=\"" + this.getSchema().getName() + "\"       id=\"" + this.getSchema().getItemID() + "\" version=\"" + this.getSchema().getVersion() + "\"/>") + (this.getScript() == null ? "" : "<Script       name=\"" + this.getScript().getName() + "\"       id=\"" + this.getScript().getItemID() + "\" version=\"" + this.getScript().getVersion() + "\"/>") + (this.getQuery() == null ? "" : "<Query        name=\"" + this.getQuery().getName() + "\"       id=\"" + this.getQuery().getItemID() + "\" version=\"" + this.getQuery().getVersion() + "\"/>");
    }
}

