/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle;

import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.graph.traversal.GraphTraversal;
import org.cristalise.kernel.lifecycle.XOrSplitDef;
import org.cristalise.kernel.lifecycle.instance.Loop;
import org.cristalise.kernel.lifecycle.instance.WfVertex;

public class LoopDef
extends XOrSplitDef {
    public boolean hasLoop = false;
    public int isNext = 0;

    @Override
    public boolean loop() {
        return true;
    }

    @Override
    public boolean verify() {
        if (!super.verify()) {
            return false;
        }
        Vertex[] nexts = this.getOutGraphables();
        Vertex[] anteVertices = GraphTraversal.getTraversal(this.getParent().getChildrenGraphModel(), this, 1, false);
        int k = 0;
        int l = 0;
        GraphableVertex[] brothers = this.getParent().getChildren();
        for (GraphableVertex brother : brothers) {
            if (!(brother instanceof LoopDef)) continue;
            ++l;
        }
        for (Vertex next : nexts) {
            for (Vertex anteVertice : anteVertices) {
                if (!next.equals(anteVertice)) continue;
                ++k;
            }
        }
        if (k != 1 && l <= 1) {
            this.mErrors.add("bad number of pointing back nexts");
            return false;
        }
        return true;
    }

    @Override
    public boolean isLoop() {
        return true;
    }

    @Override
    public WfVertex instantiate() throws InvalidDataException, ObjectNotFoundException {
        Loop newLoop = new Loop();
        this.configureInstance(newLoop);
        return newLoop;
    }
}

