/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance;

import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.Next;
import org.cristalise.kernel.lifecycle.instance.Workflow;
import org.cristalise.kernel.lifecycle.routingHelpers.DataHelperUtility;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.cristalise.kernel.utils.Logger;

public abstract class WfVertex
extends GraphableVertex {
    public abstract void runFirst(AgentPath var1, ItemPath var2, Object var3) throws InvalidDataException;

    public WfVertex() {
        this.setIsLayoutable(true);
        this.setIsComposite(false);
    }

    public abstract void runNext(AgentPath var1, ItemPath var2, Object var3) throws InvalidDataException;

    public abstract void reinit(int var1) throws InvalidDataException;

    public void abort() {
    }

    public abstract boolean verify();

    public abstract String getErrors();

    public abstract void run(AgentPath var1, ItemPath var2, Object var3) throws InvalidDataException;

    public abstract boolean loop();

    public String getActContext() {
        return this.getPath().substring(0, this.getPath().lastIndexOf(47));
    }

    public abstract Next addNext(WfVertex var1);

    public Object evaluateProperty(ItemPath itemPath, String propName, Object locker) throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        return this.evaluatePropertyValue(itemPath, this.getProperties().get(propName), locker);
    }

    public Object evaluatePropertyValue(ItemPath itemPath, Object propValue, Object locker) throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        if (itemPath == null) {
            itemPath = this.getWf().getItemPath();
        }
        return DataHelperUtility.evaluateValue(itemPath, propValue, this.getActContext(), locker);
    }

    protected Object evaluateScript(String scriptName, Integer scriptVersion, ItemPath itemPath, Object locker) throws ScriptingEngineException {
        try {
            if (itemPath == null) {
                itemPath = this.getWf().getItemPath();
            }
            Script script = Script.getScript(scriptName, scriptVersion);
            return script.evaluate(itemPath, this.getProperties(), this.getActContext(), locker);
        }
        catch (Exception e) {
            Logger.error(e);
            throw new ScriptingEngineException(e.getMessage());
        }
    }

    public Workflow getWf() {
        return ((CompositeActivity)this.getParent()).getWf();
    }

    public static enum Types {
        Atomic,
        Composite,
        OrSplit,
        XOrSplit,
        AndSplit,
        LoopSplit,
        Join,
        Route;

    }
}

