/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.CorbaServer;
import org.cristalise.kernel.entity.agent.ActiveEntity;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.predefined.item.CreateItemFromDescription;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.utils.Logger;

public class CreateAgentFromDescription
extends CreateItemFromDescription {
    @Override
    protected String runActivityLogic(AgentPath agentPath, ItemPath itemPath, int transitionID, String requestData, Object locker) throws ObjectNotFoundException, InvalidDataException, ObjectAlreadyExistsException, CannotManageException, ObjectCannotBeUpdated, PersistencyException {
        Object[] input = CreateAgentFromDescription.getDataList(requestData);
        if (Logger.doLog(3)) {
            Logger.msg(3, "CreateAgentFromDescription: called by " + agentPath + " on " + itemPath + " with parameters " + Arrays.toString(input));
        }
        String newName = input[0];
        String domPath = input[1];
        String descVer = input.length > 2 ? input[2] : "last";
        Logger.msg(1, "CreateAgentFromDescription - Starting.");
        try {
            Gateway.getLookup().getAgentPath(newName);
            throw new ObjectAlreadyExistsException("The agent name " + newName + " exists already.");
        }
        catch (ObjectNotFoundException ex) {
            DomainPath context = new DomainPath(new DomainPath(domPath), newName);
            if (context.exists()) {
                throw new ObjectAlreadyExistsException("The path " + context + " exists already.");
            }
            Logger.msg(6, "CreateAgentFromDescription - Requesting new agent path");
            AgentPath newAgentPath = new AgentPath(new ItemPath(), newName);
            Logger.msg(3, "CreateAgentFromDescription - Creating Agent");
            CorbaServer factory = Gateway.getCorbaServer();
            if (factory == null) {
                throw new CannotManageException("This process cannot create new Items");
            }
            ActiveEntity newAgent = factory.createAgent(newAgentPath);
            Gateway.getLookupManager().add(newAgentPath);
            Gateway.getLookupManager().addRole(newAgentPath, Gateway.getLookup().getRolePath(""));
            Logger.msg(3, "CreateAgentFromDescription - Initializing Agent");
            try {
                PropertyArrayList initProps = input.length > 3 ? this.unmarshallInitProperties((String)input[3]) : new PropertyArrayList();
                PropertyArrayList newProps = this.instantiateProperties(itemPath, descVer, initProps, newName, agentPath, locker);
                CollectionArrayList newColls = this.instantiateCollections(itemPath, descVer, newProps, locker);
                CompositeActivity newWorkflow = this.instantiateWorkflow(itemPath, descVer, locker);
                newAgent.initialise(agentPath.getSystemKey(), Gateway.getMarshaller().marshall(newProps), Gateway.getMarshaller().marshall(newWorkflow), Gateway.getMarshaller().marshall(newColls));
            }
            catch (PersistencyException e) {
                Logger.error((Throwable)((Object)e));
                throw e;
            }
            catch (Exception e) {
                throw new InvalidDataException("CreateAgentFromDescription: Problem initializing new Agent. See log: " + e.getMessage());
            }
            context.setItemPath(newAgentPath);
            Gateway.getLookupManager().add(context);
            return requestData;
        }
    }
}

