/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionMember;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;

public class RemoveSlotFromCollection
extends PredefinedStep {
    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, ObjectNotFoundException, PersistencyException {
        Collection coll;
        String collName;
        int slotNo = -1;
        ItemPath currentChild = null;
        Object[] params = RemoveSlotFromCollection.getDataList(requestData);
        if (Logger.doLog(3)) {
            Logger.msg(3, "RemoveSlotFromCollection: called by " + agent + " on " + item + " with parameters " + Arrays.toString(params));
        }
        try {
            collName = params[0];
            if (params.length > 1 && params[1].length() > 0) {
                slotNo = Integer.parseInt((String)params[1]);
            }
            if (params.length > 2 && ((String)params[2]).length() > 0) {
                try {
                    currentChild = new ItemPath((String)params[2]);
                }
                catch (InvalidItemPathException e) {
                    currentChild = new DomainPath((String)params[2]).getItemPath();
                }
            }
        }
        catch (Exception e) {
            throw new InvalidDataException("RemoveSlotFromCollection: Invalid parameters " + Arrays.toString(params));
        }
        if (slotNo == -1 && currentChild == null) {
            throw new InvalidDataException("RemoveSlotFromCollection: Must give either slot number or item UUID");
        }
        try {
            coll = (Collection)Gateway.getStorage().get(item, "Collection/" + collName + "/last", locker);
        }
        catch (PersistencyException ex) {
            Logger.error((Throwable)((Object)ex));
            throw new PersistencyException("RemoveSlotFromCollection: Error loading collection '\"+collName+\"': " + ex.getMessage());
        }
        CollectionMember slot = null;
        if (slotNo > -1) {
            slot = (CollectionMember)coll.getMember(slotNo);
        }
        if (slot != null && currentChild != null && !slot.getItemPath().equals(currentChild)) {
            throw new ObjectNotFoundException("RemoveSlotFromCollection: Item " + currentChild + " was not in slot " + slotNo);
        }
        if (slotNo == -1) {
            for (CollectionMember member : coll.getMembers().list) {
                if (!member.getItemPath().equals(currentChild)) continue;
                slotNo = member.getID();
                break;
            }
        }
        if (slotNo == -1) {
            throw new ObjectNotFoundException("Could not find " + currentChild + " in collection " + coll.getName());
        }
        coll.removeMember(slotNo);
        try {
            Gateway.getStorage().put(item, coll, locker);
        }
        catch (PersistencyException e) {
            Logger.error((Throwable)((Object)e));
            throw new PersistencyException("Error storing collection");
        }
        return requestData;
    }
}

