/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;

public class WriteViewpoint
extends PredefinedStep {
    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, ObjectNotFoundException, PersistencyException {
        int eventId;
        Object[] params = WriteViewpoint.getDataList(requestData);
        if (Logger.doLog(3)) {
            Logger.msg(3, "WriteViewpoint: called by " + agent + " on " + item + " with parameters " + Arrays.toString(params));
        }
        if (params.length != 3) {
            throw new InvalidDataException("WriteViewpoint: Invalid parameters " + Arrays.toString(params));
        }
        String schemaName = params[0];
        String viewName = params[1];
        try {
            eventId = Integer.parseInt((String)params[2]);
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException("WriteViewpoint: Parameter 3 (EventId) must be an integer");
        }
        WriteViewpoint.write(item, schemaName, viewName, eventId, locker);
        return requestData;
    }

    public static void write(ItemPath item, String schemaName, String viewName, int eventId, Object locker) throws PersistencyException, ObjectNotFoundException, InvalidDataException {
        Event event = (Event)Gateway.getStorage().get(item, "AuditTrail/" + eventId, locker);
        if (StringUtils.isBlank((CharSequence)event.getSchemaName())) {
            throw new InvalidDataException("Event " + eventId + " does not reference an Outcome, so cannot be assigned to a Viewpoint.");
        }
        Schema thisSchema = LocalObjectLoader.getSchema(schemaName, event.getSchemaVersion());
        if (!event.getSchemaName().equals(thisSchema.getItemID())) {
            throw new InvalidDataException("Event outcome schema is " + event.getSchemaName() + ", and cannot be used for a " + schemaName + " Viewpoint");
        }
        Gateway.getStorage().put(item, new Viewpoint(item, thisSchema, viewName, eventId), locker);
    }
}

