/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined.agent;

import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lifecycle.instance.predefined.item.Erase;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.InvalidAgentPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;

public class RemoveAgent
extends Erase {
    public RemoveAgent() {
        this.getProperties().put("Agent Role", "Admin");
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath itemPath, int transitionID, String requestData, Object locker) throws InvalidDataException, ObjectNotFoundException, ObjectCannotBeUpdated, CannotManageException, PersistencyException {
        AgentPath targetAgent;
        Logger.msg(1, "RemoveAgent::request() - Starting.");
        try {
            targetAgent = new AgentPath(itemPath);
        }
        catch (InvalidAgentPathException ex) {
            throw new InvalidDataException("Could not resolve " + itemPath + " as an Agent.");
        }
        String agentName = targetAgent.getAgentName();
        for (RolePath role : targetAgent.getRoles()) {
            try {
                Gateway.getLookupManager().removeRole(targetAgent, role);
            }
            catch (ObjectCannotBeUpdated e) {
                Logger.error((Throwable)((Object)e));
                throw new InvalidDataException("Error removing " + agentName + " from Role " + role.getName());
            }
            catch (ObjectNotFoundException e) {
                Logger.error((Throwable)((Object)e));
                throw new InvalidDataException("Tried to remove " + agentName + " from Role " + role.getName() + " that doesn't exist.");
            }
            catch (CannotManageException e) {
                throw new InvalidDataException("Tried to alter roles in a non-server process.");
            }
        }
        return super.runActivityLogic(agent, itemPath, transitionID, requestData, locker);
    }
}

