/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined.agent;

import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;

public class SetAgentPassword
extends PredefinedStep {
    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, ObjectNotFoundException, ObjectCannotBeUpdated, CannotManageException {
        AgentPath targetAgent;
        Object[] params = SetAgentPassword.getDataList(requestData);
        if (Logger.doLog(3)) {
            Logger.msg(3, "SetAgentPassword: called by " + agent + " on " + item + " with parameters " + Arrays.toString(params));
        }
        if (params.length != 1) {
            throw new InvalidDataException("SetAgentPassword: Invalid parameters " + Arrays.toString(params));
        }
        try {
            targetAgent = new AgentPath(item);
        }
        catch (InvalidItemPathException ex) {
            throw new InvalidDataException("Can only set password on an Agent. " + item + " is an Item.");
        }
        if (!targetAgent.equals(agent) && !agent.hasRole("Admin")) {
            throw new InvalidDataException("Agent passwords may only be set by those Agents or by an Administrator");
        }
        try {
            Gateway.getLookupManager().setAgentPassword(targetAgent, (String)params[0]);
        }
        catch (NoSuchAlgorithmException e) {
            Logger.error(e);
            throw new InvalidDataException("Cryptographic libraries for password hashing not found.");
        }
        params[0] = "REDACTED";
        return SetAgentPassword.bundleData((String[])params);
    }
}

