/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined.server;

import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.imports.ImportAgent;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;

public class CreateNewAgent
extends PredefinedStep {
    public CreateNewAgent() {
        this.setBuiltInProperty(BuiltInVertexProperties.SCHEMA_NAME, "Agent");
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, ObjectNotFoundException, ObjectCannotBeUpdated, CannotManageException, ObjectAlreadyExistsException {
        String redactedRequestData;
        ImportAgent newAgent;
        try {
            newAgent = (ImportAgent)Gateway.getMarshaller().unmarshall(requestData);
        }
        catch (Exception e1) {
            Logger.error(e1);
            throw new InvalidDataException("CreateNewAgent: Couldn't unmarshall new Agent: " + requestData);
        }
        newAgent.create(agent, true);
        newAgent.setPassword("REDACTED");
        try {
            redactedRequestData = Gateway.getMarshaller().marshall(newAgent);
        }
        catch (Exception e) {
            Logger.error(e);
            throw new InvalidDataException("CreateNewAgent: Couldn't marshall new Agent for outcome: " + newAgent);
        }
        return redactedRequestData;
    }
}

