/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.routingHelpers;

import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lifecycle.routingHelpers.ActivityDataHelper;
import org.cristalise.kernel.lifecycle.routingHelpers.BuiltInDataHelpers;
import org.cristalise.kernel.lifecycle.routingHelpers.DataHelper;
import org.cristalise.kernel.lifecycle.routingHelpers.PropertyDataHelper;
import org.cristalise.kernel.lifecycle.routingHelpers.ViewpointDataHelper;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;

public class DataHelperUtility {
    public static DataHelper getDataHelper(String id) throws InvalidDataException {
        Object configHelper = Gateway.getProperties().getObject("DataHelper." + id);
        if (configHelper != null) {
            if (configHelper instanceof DataHelper) {
                return (DataHelper)configHelper;
            }
            throw new InvalidDataException("Config value is not an instance of DataHelper - 'DataHelper." + id + "'=" + configHelper.toString());
        }
        switch (BuiltInDataHelpers.getValue(id)) {
            case VIEWPOINT_DH: {
                return new ViewpointDataHelper();
            }
            case PROPERTY_DH: {
                return new PropertyDataHelper();
            }
            case ACTIVITY_DH: {
                return new ActivityDataHelper();
            }
        }
        Logger.warning("DataHelperUtility.getDataHelper() - UNKOWN DataHelper id:" + id);
        return null;
    }

    public static Object evaluateValue(ItemPath itemPath, Object value, String actContext, Object locker) throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        if (value == null || !(value instanceof String) || !((String)value).contains("//")) {
            return value;
        }
        if (itemPath == null) {
            throw new InvalidDataException("DataHelper must have ItemPath initialised");
        }
        String[] valueSplit = ((String)value).split("//");
        if (valueSplit.length != 2) {
            throw new InvalidDataException("DataHelperUtility.evaluateValue() - Too many '//' in value:" + value);
        }
        String pathType = valueSplit[0];
        String dataPath = valueSplit[1];
        Logger.msg(5, "DataHelperUtility.evaluateValue() - pathType:" + pathType + " dataPath:" + dataPath);
        DataHelper dataHelper = DataHelperUtility.getDataHelper(pathType);
        if (dataHelper != null) {
            return dataHelper.get(itemPath, actContext, dataPath, locker);
        }
        return value;
    }
}

