/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lookup;

import java.util.UUID;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.SystemKey;
import org.cristalise.kernel.lookup.InvalidAgentPathException;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.process.Gateway;

public class AgentPath
extends ItemPath {
    private String mAgentName = null;

    public AgentPath(UUID uuid, String ior, String agentName) {
        super(uuid, ior);
        this.mAgentName = agentName;
    }

    public AgentPath(UUID uuid) throws InvalidAgentPathException {
        super(uuid);
    }

    public AgentPath(SystemKey syskey) throws InvalidAgentPathException {
        this(new UUID(syskey.msb, syskey.lsb));
    }

    public AgentPath(ItemPath itemPath) throws InvalidAgentPathException {
        this(itemPath.mUUID);
    }

    public AgentPath(String path) throws InvalidItemPathException {
        this(UUID.fromString(path.substring(path.lastIndexOf("/") == -1 ? 0 : path.lastIndexOf("/") + 1)));
    }

    public AgentPath(ItemPath itemPath, String agentName) {
        super(itemPath.mUUID);
        this.mAgentName = agentName;
    }

    public AgentPath(UUID uuid, String agentName) {
        super(uuid);
        this.mAgentName = agentName;
    }

    public void setAgentName(String agentID) {
        this.mAgentName = agentID;
    }

    public String getAgentName() {
        if (this.mAgentName == null) {
            try {
                this.mAgentName = Gateway.getLookup().getAgentName(this);
            }
            catch (ObjectNotFoundException e) {
                return null;
            }
        }
        return this.mAgentName;
    }

    public RolePath[] getRoles() {
        return Gateway.getLookup().getRoles(this);
    }

    public boolean hasRole(RolePath role) {
        return Gateway.getLookup().hasRole(this, role);
    }

    public boolean hasRole(String role) {
        try {
            return this.hasRole(Gateway.getLookup().getRolePath(role));
        }
        catch (ObjectNotFoundException ex) {
            return false;
        }
    }

    @Override
    public String dump() {
        return super.dump() + "\n        agentID=" + this.mAgentName;
    }
}

