/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lookup;

import java.util.UUID;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.SystemKey;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.process.Gateway;
import org.omg.CORBA.Object;

public class DomainPath
extends Path {
    private ItemPath target = null;

    public DomainPath() {
    }

    public DomainPath(String[] path) {
        super(path);
    }

    public DomainPath(String path) {
        super(path);
    }

    public DomainPath(String path, ItemPath entity) {
        super(path);
        this.setItemPath(entity);
    }

    public DomainPath(DomainPath parent, String child) {
        super(parent, child);
    }

    @Override
    public String getRoot() {
        return "domain";
    }

    public DomainPath getParent() {
        if (this.mPath.length == 0) {
            return null;
        }
        String[] parentPath = new String[this.mPath.length - 1];
        System.arraycopy(this.mPath, 0, parentPath, 0, parentPath.length);
        return new DomainPath(parentPath);
    }

    public void setItemPath(ItemPath newTarget) {
        this.target = newTarget;
    }

    public ItemPath getTarget() {
        return this.target;
    }

    @Override
    public ItemPath getItemPath() throws ObjectNotFoundException {
        if (this.target == null) {
            try {
                this.setItemPath(Gateway.getLookup().resolvePath(this));
                if (this.target == null) {
                    throw new ObjectNotFoundException("Path " + this.toString() + " does not resolve to an Item");
                }
            }
            catch (InvalidItemPathException e) {
                throw new ObjectNotFoundException(e.getMessage());
            }
        }
        return this.target;
    }

    public boolean isContext() {
        return this.target == null;
    }

    public String getName() {
        if (this.mPath.length > 0) {
            return this.mPath[this.mPath.length - 1];
        }
        return this.getRoot();
    }

    @Override
    public Object getIOR() {
        return null;
    }

    @Override
    public SystemKey getSystemKey() {
        return null;
    }

    @Override
    public UUID getUUID() {
        return null;
    }

    @Override
    public void setIOR(Object IOR) {
    }

    @Override
    public String toString() {
        return super.toString() + " target:" + this.target;
    }
}

