/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lookup;

import java.util.Iterator;
import java.util.UUID;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.SystemKey;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.process.Gateway;
import org.omg.CORBA.Object;

public class RolePath
extends Path {
    private boolean hasJobList = false;

    public RolePath() {
    }

    public RolePath(RolePath parent, String roleName) {
        super(parent, roleName);
    }

    public RolePath(String path, boolean jobList) {
        super(path);
        this.hasJobList = jobList;
    }

    public RolePath(String[] path, boolean jobList) {
        super(path);
        this.hasJobList = jobList;
    }

    public RolePath(RolePath parent, String roleName, boolean jobList) {
        this(parent, roleName);
        this.hasJobList = jobList;
    }

    public RolePath getParent() throws ObjectNotFoundException {
        if (this.mPath.length < 2) {
            return null;
        }
        return Gateway.getLookup().getRolePath(this.mPath[this.mPath.length - 2]);
    }

    public boolean hasJobList() {
        return this.hasJobList;
    }

    public void setHasJobList(boolean hasJobList) {
        this.hasJobList = hasJobList;
    }

    public Iterator<Path> getChildren() {
        return Gateway.getLookup().getChildren(this);
    }

    @Override
    public String dump() {
        StringBuffer comp = new StringBuffer("Components: { ");
        for (String element : this.mPath) {
            comp.append("'").append(element).append("' ");
        }
        return "Path - dump(): " + comp.toString() + "}\n        string=" + this.toString() + "\n        name=" + this.getName() + "\n        ";
    }

    @Override
    public String getRoot() {
        return "role";
    }

    public String getName() {
        if (this.mPath.length > 0) {
            return this.mPath[this.mPath.length - 1];
        }
        return this.getRoot();
    }

    @Override
    public ItemPath getItemPath() throws ObjectNotFoundException {
        return null;
    }

    @Override
    public Object getIOR() {
        return null;
    }

    @Override
    public SystemKey getSystemKey() {
        return null;
    }

    @Override
    public UUID getUUID() {
        return null;
    }

    @Override
    public void setIOR(Object IOR) {
    }
}

