/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.InvalidTransitionException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.proxy.MemberSubscription;
import org.cristalise.kernel.entity.proxy.ProxyObserver;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.persistency.ClusterStorage;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.StandardClient;
import org.cristalise.kernel.scripting.ErrorInfo;
import org.cristalise.kernel.scripting.ScriptErrorException;
import org.cristalise.kernel.utils.Logger;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class UserCodeProcess
extends StandardClient
implements ProxyObserver<Job>,
Runnable {
    private final int START;
    private final int COMPLETE;
    private final int SUSPEND;
    private final int RESUME;
    static boolean active = true;
    ArrayList<String> ignoredPaths = new ArrayList();
    HashMap<String, ErrorInfo> errors = new HashMap();
    final HashMap<String, C2KLocalObject> jobs = new HashMap();

    public UserCodeProcess() throws InvalidDataException, ObjectNotFoundException {
        StateMachine sm = UserCodeProcess.getRequiredStateMachine("UserCode", null, "boot/SM/Default.xml");
        this.START = this.getValidTransitionID(sm, "UserCode.StateMachine.startTransition", "Start");
        this.COMPLETE = this.getValidTransitionID(sm, "UserCode.StateMachine.completeTransition", "Complete");
        this.SUSPEND = this.getValidTransitionID(sm, "UserCode.StateMachine.suspendTransition", "Suspend");
        this.RESUME = this.getValidTransitionID(sm, "UserCode.StateMachine.resumeTransition", "Resume");
    }

    private int getValidTransitionID(StateMachine sm, String propertyName, String defaultValue) throws InvalidDataException {
        String propertyValue = Gateway.getProperties().getString(propertyName, defaultValue);
        if ("USERCODE_IGNORE".equals(propertyValue)) {
            return -1;
        }
        return sm.getValidTransitionID(propertyValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName("Usercode Process");
        this.agent.subscribe(new MemberSubscription<Job>(this, "Job", true));
        while (active) {
            Object jobKey;
            Job thisJob = this.getActualJob();
            if (thisJob != null) {
                jobKey = thisJob.getItemPath() + ":" + thisJob.getStepPath();
                int transitionId = thisJob.getTransition().getId();
                try {
                    if (transitionId == this.START) {
                        this.start(thisJob, (String)jobKey);
                    } else if (transitionId == this.COMPLETE) {
                        this.complete(thisJob, (String)jobKey);
                    } else if (transitionId == this.SUSPEND) {
                        this.suspend(thisJob, (String)jobKey);
                    } else if (transitionId == this.RESUME) {
                        this.resume(thisJob, (String)jobKey);
                    }
                }
                catch (ScriptErrorException ex) {
                    this.errors.put((String)jobKey, ex.getErrors());
                    this.ignoredPaths.add((String)jobKey);
                }
                catch (InvalidTransitionException ex) {
                }
                catch (Throwable ex) {
                    Logger.error("Error executing " + thisJob.getTransition().getName() + " job:");
                    Logger.error(ex);
                    ErrorInfo ei = new ErrorInfo();
                    ei.setFatal();
                    ei.addError(ex.getClass().getSimpleName());
                    ei.addError(ex.getMessage());
                    this.errors.put((String)jobKey, ei);
                    this.ignoredPaths.add((String)jobKey);
                }
            }
            try {
                jobKey = this.jobs;
                synchronized (jobKey) {
                    if (this.jobs.size() == 0) {
                        Logger.msg("UserCodeProcess.run() - Sleeping");
                        while (active && this.jobs.size() == 0) {
                            this.jobs.wait(2000L);
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        try {
            Gateway.close();
        }
        catch (Exception ex) {
            Logger.error(ex);
        }
    }

    public void start(Job thisJob, String jobKey) throws AccessRightsException, InvalidDataException, InvalidTransitionException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, ScriptErrorException, InvalidCollectionModification {
        Logger.msg(5, "UserCodeProcess.start() - job:" + thisJob);
        if (this.assessStartConditions(thisJob)) {
            Logger.msg(5, "UserCodeProcess.start() - Attempting to start");
            this.agent.execute(thisJob);
        } else {
            Logger.msg(5, "UserCodeProcess.start() - Start conditions failed " + thisJob.getStepName() + " in " + thisJob.getItemPath());
        }
    }

    public void complete(Job thisJob, String jobKey) throws Exception {
        Logger.msg(5, "UserCodeProcess.complete() - job:" + thisJob);
        this.runUserCodeLogic(thisJob);
        if (this.ignoredPaths.contains(jobKey)) {
            this.ignoredPaths.remove(jobKey);
        }
    }

    public void resume(Job thisJob, String jobKey) throws AccessRightsException, InvalidDataException, InvalidTransitionException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, ScriptErrorException, InvalidCollectionModification {
        Logger.msg(5, "UserCodeProcess.resume() - job:" + thisJob);
        if (!this.ignoredPaths.contains(jobKey)) {
            this.agent.execute(thisJob);
        }
    }

    public void suspend(Job thisJob, String jobKey) throws MarshalException, ValidationException, InvalidDataException, ObjectNotFoundException, IOException, MappingException, AccessRightsException, InvalidTransitionException, PersistencyException, ObjectAlreadyExistsException, InvalidCollectionModification, ScriptErrorException {
        Logger.msg(5, "UserCodeProcess.suspend() - job:" + thisJob);
        if (this.ignoredPaths.contains(jobKey)) {
            if (this.errors.containsKey(jobKey)) {
                thisJob.setOutcome(Gateway.getMarshaller().marshall(this.errors.get(jobKey)));
                this.errors.remove(jobKey);
            }
            this.agent.execute(thisJob);
        }
    }

    public boolean assessStartConditions(Job job) {
        return true;
    }

    public void runUserCodeLogic(Job job) throws AccessRightsException, InvalidDataException, InvalidTransitionException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, InvalidCollectionModification, ScriptErrorException {
        this.agent.execute(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Job getActualJob() {
        Job thisJob = null;
        HashMap<String, C2KLocalObject> hashMap = this.jobs;
        synchronized (hashMap) {
            if (this.jobs.size() > 0) {
                thisJob = UserCodeProcess.getJob(this.jobs, this.COMPLETE);
                if (thisJob == null) {
                    thisJob = UserCodeProcess.getJob(this.jobs, this.START);
                }
                if (thisJob == null) {
                    thisJob = UserCodeProcess.getJob(this.jobs, this.SUSPEND);
                }
                if (thisJob == null) {
                    thisJob = UserCodeProcess.getJob(this.jobs, this.RESUME);
                }
                if (thisJob == null) {
                    Logger.error("No supported jobs, but joblist is not empty! Discarding remaining jobs");
                    this.jobs.clear();
                } else {
                    this.jobs.remove(ClusterStorage.getPath(thisJob));
                }
            }
        }
        return thisJob;
    }

    private static Job getJob(HashMap<String, C2KLocalObject> jobs, int transition) {
        for (C2KLocalObject c2kLocalObject : jobs.values()) {
            Job thisJob = (Job)c2kLocalObject;
            if (thisJob.getTransition().getId() != transition) continue;
            Logger.msg(1, "=================================================================");
            Logger.msg(5, "UserCodeProcess.getJob() - job:" + thisJob);
            return thisJob;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Job contents) {
        HashMap<String, C2KLocalObject> hashMap = this.jobs;
        synchronized (hashMap) {
            Logger.msg(7, "UserCodeProcess.add() - path:" + ClusterStorage.getPath(contents));
            this.jobs.put(ClusterStorage.getPath(contents), contents);
            this.jobs.notify();
        }
    }

    @Override
    public void control(String control, String msg) {
        if ("Error".equals(control)) {
            Logger.error("Error in job subscription: " + msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String id) {
        HashMap<String, C2KLocalObject> hashMap = this.jobs;
        synchronized (hashMap) {
            Logger.msg(7, "UserCodeProcess.remove() - id:" + id);
            this.jobs.remove(id);
        }
    }

    public String getDesc() {
        return "Usercode Process";
    }

    public static void shutdown() {
        active = false;
    }

    public static void main(String[] args) {
        int status = 0;
        try {
            Gateway.init(UserCodeProcess.readC2KArgs(args));
            UserCodeProcess proc = new UserCodeProcess();
            proc.login(Gateway.getProperties().getString("UserCode.agent", InetAddress.getLocalHost().getHostName()), Gateway.getProperties().getString("UserCode.password", "uc"), Gateway.getProperties().getString("AuthResource", "Cristal"));
            new Thread(proc).start();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    UserCodeProcess.shutdown();
                }
            }));
        }
        catch (Exception ex) {
            Logger.error(ex);
            try {
                Gateway.close();
            }
            catch (Exception ex1) {
                Logger.error(ex1);
            }
            status = 1;
            System.exit(status);
        }
    }
}

