/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process.module;

import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import org.cristalise.kernel.collection.BuiltInCollections;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionMember;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.imports.ImportAgent;
import org.cristalise.kernel.entity.imports.ImportDependency;
import org.cristalise.kernel.entity.imports.ImportDependencyMember;
import org.cristalise.kernel.entity.imports.ImportItem;
import org.cristalise.kernel.entity.imports.ImportOutcome;
import org.cristalise.kernel.entity.imports.ImportRole;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.process.Bootstrap;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.module.ModuleActivity;
import org.cristalise.kernel.process.module.ModuleConfig;
import org.cristalise.kernel.process.module.ModuleImport;
import org.cristalise.kernel.process.module.ModuleImports;
import org.cristalise.kernel.process.module.ModuleInfo;
import org.cristalise.kernel.process.module.ModuleResource;
import org.cristalise.kernel.process.module.ModuleScript;
import org.cristalise.kernel.process.module.ModuleWorkflow;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.scripting.ErrorInfo;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.cristalise.kernel.utils.Logger;

public class Module
extends ImportItem {
    private ModuleInfo info;
    private String resURL;
    private ModuleImports imports = new ModuleImports();
    private ArrayList<ModuleConfig> config = new ArrayList();
    private ArrayList<ModuleScript> scripts = new ArrayList();

    public Module() {
        this.properties.add(new Property(BuiltInItemProperties.TYPE, "Module", false));
        this.setInitialPath(BuiltInResources.MODULE_RESOURCE.getTypeRoot());
        this.setWorkflow(BuiltInResources.MODULE_RESOURCE.getWorkflowDef());
        this.setWorkflowVer(0);
    }

    public void runScript(String event, AgentProxy agent, boolean isServer) throws ScriptingEngineException {
        for (ModuleScript script : this.scripts) {
            if (!script.shouldRun(event, isServer)) continue;
            Logger.msg("Running " + script.event + " " + script.target + " script from " + this.name);
            Object result = script.getScript(this.ns, agent).execute();
            if (result instanceof ErrorInfo) {
                ErrorInfo error = (ErrorInfo)result;
                Logger.error(error.toString());
                if (!error.getFatal()) continue;
                throw new ScriptingEngineException("Fatal Script Error");
            }
            if (result == null) continue;
            Logger.msg(result.toString());
        }
    }

    public void setModuleXML(String moduleXML) {
        ImportOutcome moduleOutcome = new ImportOutcome("Module", 0, "last", null);
        moduleOutcome.data = moduleXML;
        this.outcomes.add(moduleOutcome);
    }

    @Override
    public void setNamespace(String ns) {
        super.setNamespace(ns);
        this.replaceProp(new Property(BuiltInItemProperties.NAMESPACE, ns, false));
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.replaceProp(new Property(BuiltInItemProperties.NAME, name, false));
    }

    private void replaceProp(Property newProp) {
        for (Property prop : this.properties) {
            if (!prop.getName().equals("Namespace")) continue;
            prop.setMutable(newProp.isMutable());
            prop.setValue(newProp.getValue());
            return;
        }
        this.properties.add(newProp);
    }

    public void importAll(ItemProxy serverEntity, AgentProxy systemAgent, boolean reset) throws Exception {
        if (!Bootstrap.shutdown) {
            this.importResources(systemAgent, reset);
        }
        if (!Bootstrap.shutdown) {
            this.importRoles(systemAgent, reset);
        }
        if (!Bootstrap.shutdown) {
            this.importAgents(systemAgent, reset);
        }
        if (!Bootstrap.shutdown) {
            this.importItems(systemAgent, reset);
        }
        if (!Bootstrap.shutdown) {
            this.create(systemAgent.getPath(), reset);
        }
    }

    private void importItems(AgentProxy systemAgent, boolean reset) throws Exception {
        for (ImportItem thisItem : this.imports.getItems()) {
            if (Bootstrap.shutdown) {
                return;
            }
            thisItem.setNamespace(this.ns);
            thisItem.create(systemAgent.getPath(), reset);
        }
    }

    private void importAgents(AgentProxy systemAgent, boolean reset) throws Exception {
        for (ImportAgent thisAgent : this.imports.getAgents()) {
            if (Bootstrap.shutdown) {
                return;
            }
            try {
                Gateway.getLookup().getAgentPath(thisAgent.name);
                Logger.msg(3, "Module.importAgents() - Agent '" + thisAgent.name + "' found.");
            }
            catch (ObjectNotFoundException ex) {
                Logger.msg("Module.importAgents() - Agent '" + thisAgent.name + "' not found. Creating.");
                thisAgent.create(systemAgent.getPath(), reset);
            }
        }
    }

    private void importRoles(AgentProxy systemAgent, boolean reset) throws Exception {
        for (ImportRole thisRole : this.imports.getRoles()) {
            if (Bootstrap.shutdown) {
                return;
            }
            thisRole.create(systemAgent.getPath(), reset);
        }
    }

    private void importResources(AgentProxy systemAgent, boolean reset) {
        for (ModuleResource thisRes : this.imports.getResources()) {
            if (Bootstrap.shutdown) {
                return;
            }
            try {
                thisRes.setNamespace(this.ns);
                thisRes.create(systemAgent.getPath(), reset);
            }
            catch (Exception ex) {
                Logger.error(ex);
                Logger.die("Error importing module resources. Unsafe to continue.");
            }
        }
    }

    public Properties getProperties(boolean isServer) {
        Properties props = new Properties();
        for (ModuleConfig thisProp : this.config) {
            if (!thisProp.include(isServer)) continue;
            props.put(thisProp.name, thisProp.value);
        }
        return props;
    }

    public ArrayList<ModuleScript> getScripts() {
        return this.scripts;
    }

    public void setResURL(String resURL) {
        this.resURL = resURL;
    }

    public String getDesc() {
        return this.info.desc;
    }

    public String getVersion() {
        return this.info.version;
    }

    public String getResURL() {
        return this.resURL;
    }

    public ArrayList<String> getDependencies() {
        return this.info.dependency;
    }

    public boolean hasDependency(String dep) {
        return this.info.dependency.contains(dep);
    }

    public ModuleInfo getInfo() {
        return this.info;
    }

    public void setInfo(ModuleInfo info) {
        this.info = info;
        this.replaceProp(new Property(BuiltInItemProperties.VERSION, info.version, true));
    }

    public ModuleImports getImports() {
        return this.imports;
    }

    public void setImports(ModuleImports theImports) {
        this.imports = theImports;
        ImportDependency children = new ImportDependency(BuiltInCollections.CONTENTS);
        for (ModuleImport thisImport : this.imports.list) {
            DomainPath path = thisImport.domainPath;
            if (path == null) continue;
            children.dependencyMemberList.add(new ImportDependencyMember(path.toString()));
        }
        this.dependencyList.add(children);
    }

    public void setImports(Collection<?> contents) throws ObjectNotFoundException, InvalidDataException {
        this.imports.list.clear();
        this.addImports(contents);
    }

    public void addImports(Collection<?> contents) throws ObjectNotFoundException, InvalidDataException {
        for (CollectionMember mem : contents.getMembers().list) {
            ModuleResource newImport;
            String[] type;
            if (mem.getItemPath() == null) continue;
            ItemProxy child = mem.resolveItem();
            String name = child.getName();
            Integer version = Integer.valueOf(mem.getProperties().get("Version").toString());
            switch (type = child.getProperty(BuiltInItemProperties.TYPE)) {
                case "ActivityDesc": {
                    String complex = child.getProperty(BuiltInItemProperties.COMPLEXITY);
                    if (complex.equals("Elementary")) {
                        newImport = new ModuleActivity(child, version);
                        break;
                    }
                    newImport = new ModuleWorkflow(child, version);
                    break;
                }
                case "Script": 
                case "Query": 
                case "StateMachine": 
                case "Schema": {
                    newImport = new ModuleResource();
                    break;
                }
                default: {
                    throw new InvalidDataException("Resource type '" + (String)type + "' unknown for module export");
                }
            }
            newImport.setName(name);
            newImport.setItemPath(mem.getItemPath());
            newImport.setNamespace(this.getNamespace());
            if (this.imports.list.contains(newImport)) continue;
            try {
                String childModule = child.getProperty("Module");
                if (childModule != null && childModule.length() > 0 && !childModule.equals(this.getNamespace())) {
                    return;
                }
            }
            catch (ObjectNotFoundException ex) {
                // empty catch block
            }
            this.imports.list.add(newImport);
            for (String collName : child.getContents("Collection")) {
                Collection<?> childColl = child.getCollection(collName, version);
                this.addImports(childColl);
            }
        }
    }

    public void setConfig(ArrayList<ModuleConfig> config) {
        this.config = config;
    }

    public void setScripts(ArrayList<ModuleScript> scripts) {
        this.scripts = scripts;
    }

    public ArrayList<ModuleConfig> getConfig() {
        return this.config;
    }

    public void export(File location) {
    }
}

