/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process.module;

import java.util.ArrayList;
import org.cristalise.kernel.collection.BuiltInCollections;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionMember;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.ActivityDef;
import org.cristalise.kernel.lifecycle.CompositeActivityDef;
import org.cristalise.kernel.process.module.ModuleActivity;
import org.cristalise.kernel.process.module.ModuleDescRef;
import org.cristalise.kernel.process.resource.BuiltInResources;

public class ModuleWorkflow
extends ModuleActivity {
    ArrayList<ModuleDescRef> activities = new ArrayList();

    public ModuleWorkflow() {
        this.resourceType = BuiltInResources.COMP_ACT_DESC_RESOURCE.getTypeCode();
    }

    public ModuleWorkflow(ItemProxy child, Integer version) throws ObjectNotFoundException, InvalidDataException {
        super(child, version);
        Collection<?> coll = child.getCollection(BuiltInCollections.ACTIVITY, version);
        for (CollectionMember collMem : coll.getMembers().list) {
            this.activities.add(new ModuleDescRef(null, collMem.getChildUUID(), Integer.valueOf(collMem.getProperties().getBuiltInProperty(BuiltInVertexProperties.VERSION).toString())));
        }
    }

    public ArrayList<ModuleDescRef> getActivities() {
        return this.activities;
    }

    public void setActivities(ArrayList<ModuleDescRef> activities) {
        this.activities = activities;
    }

    @Override
    public void populateActivityDef() throws ObjectNotFoundException, CannotManageException {
        super.populateActivityDef();
        CompositeActivityDef compActDef = (CompositeActivityDef)this.actDef;
        ArrayList<ActivityDef> graphActDefs = compActDef.getRefChildActDef();
        if (this.activities.size() != graphActDefs.size()) {
            throw new CannotManageException("There were " + this.activities.size() + " declared activities, but the graph uses " + graphActDefs.size());
        }
        for (ModuleDescRef moduleDescRef : this.activities) {
            boolean found = false;
            for (ActivityDef childActDef : graphActDefs) {
                if (!childActDef.getName().equals(moduleDescRef.getName()) || !childActDef.getVersion().equals(moduleDescRef.getVersion())) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new CannotManageException("Graphed child activity " + moduleDescRef.getName() + " v" + moduleDescRef.getVersion() + " not referenced in module for " + this.getName());
        }
    }
}

