/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process.resource;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.process.resource.ResourceLoader;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.Logger;

public class Resource
implements ResourceLoader {
    private final Hashtable<String, String> txtCache = new Hashtable();
    private final URL baseURL;
    private final HashMap<String, URL> moduleBaseURLs = new HashMap();
    private final HashMap<String, URL> allBaseURLs = new HashMap();

    public Resource() throws InvalidDataException {
        this.baseURL = Resource.getURLorResURL("org/cristalise/kernel/utils/resources/");
        this.allBaseURLs.put(null, this.baseURL);
    }

    @Override
    public URL getKernelBaseURL() {
        return this.baseURL;
    }

    @Override
    public ClassLoader getClassLoader(String className) {
        return Resource.class.getClassLoader();
    }

    @Override
    public Class<?> getClassForName(String name) throws ClassNotFoundException {
        return Class.forName(name);
    }

    @Override
    public URL getKernelResourceURL(String resName) throws MalformedURLException {
        return new URL(this.baseURL, resName);
    }

    @Override
    public void addModuleBaseURL(String ns, URL newBaseURL) {
        this.moduleBaseURLs.put(ns, newBaseURL);
        this.allBaseURLs.put(ns, newBaseURL);
        Logger.msg("Adding resource URL for " + ns + ": " + newBaseURL.toString());
    }

    @Override
    public void addModuleBaseURL(String ns, String newBaseURL) throws InvalidDataException {
        this.addModuleBaseURL(ns, Resource.getURLorResURL(newBaseURL));
    }

    @Override
    public HashMap<String, URL> getModuleBaseURLs() {
        return this.moduleBaseURLs;
    }

    private HashMap<String, URL> getAllBaseURLs() {
        return this.allBaseURLs;
    }

    @Override
    public URL getModuleResourceURL(String ns, String resName) throws MalformedURLException {
        if (!this.moduleBaseURLs.containsKey(ns)) {
            throw new MalformedURLException("Could not locate resource. Namespace '" + ns + "' not registered.");
        }
        return new URL(this.moduleBaseURLs.get(ns), resName);
    }

    private static URL getURLorResURL(String newURL) throws InvalidDataException {
        URL result;
        try {
            result = new URL(newURL);
        }
        catch (MalformedURLException ex) {
            result = Resource.class.getClassLoader().getResource(newURL);
        }
        if (result == null) {
            Logger.error("URL " + newURL + " could not be found");
            throw new InvalidDataException();
        }
        return result;
    }

    @Override
    public String findTextResource(String resName) {
        for (String ns : this.getAllBaseURLs().keySet()) {
            try {
                return this.getTextResource(ns, resName);
            }
            catch (ObjectNotFoundException ex) {
            }
        }
        Logger.warning("Text resource '" + resName + "' not found.");
        return null;
    }

    @Override
    public HashMap<String, String> getAllTextResources(String resName) {
        HashMap<String, String> results = new HashMap<String, String>();
        for (String ns : this.getAllBaseURLs().keySet()) {
            try {
                results.put(ns, this.getTextResource(ns, resName));
            }
            catch (ObjectNotFoundException ex) {}
        }
        return results;
    }

    @Override
    public String getTextResource(String ns, String resName) throws ObjectNotFoundException {
        Logger.msg(8, "Resource::getTextResource() - Getting resource from namespacce " + ns + ": " + resName);
        if (this.txtCache.containsKey(ns + '/' + resName)) {
            return this.txtCache.get(ns + '/' + resName);
        }
        try {
            String newRes = null;
            URL loc = ns == null ? this.getKernelResourceURL(resName) : this.getModuleResourceURL(ns, resName);
            Logger.msg(5, "Loading resource: " + loc.toString());
            newRes = FileStringUtility.url2String(loc);
            this.txtCache.put(ns + '/' + resName, newRes);
            return newRes;
        }
        catch (Exception e) {
            Logger.error(e);
            throw new ObjectNotFoundException(e.getMessage());
        }
    }

    @Override
    public Enumeration<URL> getModuleDefURLs() throws Exception {
        return this.getClassLoader("").getResources("META-INF/cristal/module.xml");
    }
}

