/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.process.resource.ResourceLoader;
import org.cristalise.kernel.querying.Query;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.Logger;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLContext;

public class CastorXMLUtility {
    public static final String CASTOR_XML_SERIALIZER_FACTORY = "org.exolab.castor.xml.serializer.factory";
    private XMLContext mappingContext;

    public CastorXMLUtility(ResourceLoader aResourceLoader, Properties aAppProperties, URL mapURL) throws InvalidDataException {
        String index;
        Logger.msg(3, String.format("CastorXMLUtility.<init> Loading maps from [%s]", mapURL));
        try {
            index = FileStringUtility.url2String(new URL(mapURL, "index"));
        }
        catch (Exception e) {
            throw new InvalidDataException(String.format("Could not load map index from [%s]", mapURL));
        }
        ClassLoader defaultClassLoader = aResourceLoader.getClassLoader(CastorXMLUtility.class.getName());
        Logger.msg(3, String.format("CastorXMLUtility.<init>: defaultClassLoader=[%s]", defaultClassLoader));
        StringTokenizer sTokenizer = new StringTokenizer(index);
        int wNbMap = sTokenizer.countTokens();
        Mapping thisMapping = new Mapping(defaultClassLoader);
        HashSet<String> loadedMapURLs = new HashSet<String>();
        try {
            int wMapIdx = 0;
            while (sTokenizer.hasMoreTokens()) {
                String thisMap = sTokenizer.nextToken();
                String thisMapURL = new URL(mapURL, thisMap).toString();
                ++wMapIdx;
                if (!loadedMapURLs.contains(thisMapURL)) {
                    Logger.msg(3, String.format("CastorXMLUtility.<init>: Adding mapping file (%d/%d):[%s]", wMapIdx, wNbMap, thisMapURL));
                    thisMapping.loadMapping(new URL(thisMapURL));
                    loadedMapURLs.add(thisMapURL);
                    continue;
                }
                Logger.msg(3, "Map file already loaded:" + thisMapURL);
            }
            this.mappingContext = new XMLContext();
            this.mappingContext.setClassLoader(defaultClassLoader);
            if (aAppProperties != null && aAppProperties.containsKey(CASTOR_XML_SERIALIZER_FACTORY)) {
                this.mappingContext.setProperty(CASTOR_XML_SERIALIZER_FACTORY, (Object)aAppProperties.getProperty(CASTOR_XML_SERIALIZER_FACTORY));
                Logger.msg(3, String.format("CastorXMLUtility.<init>: castor prop: %s=[%s]", CASTOR_XML_SERIALIZER_FACTORY, this.mappingContext.getProperty(CASTOR_XML_SERIALIZER_FACTORY)));
            }
            this.mappingContext.addMapping(thisMapping);
        }
        catch (MappingException ex) {
            Logger.error(ex);
            throw new InvalidDataException("XML Mapping files are not valid: " + ex.getMessage());
        }
        catch (MalformedURLException ex) {
            Logger.error(ex);
            throw new InvalidDataException("Mapping file location invalid: " + ex.getMessage());
        }
        catch (IOException ex) {
            Logger.error(ex);
            throw new InvalidDataException("Could not read XML mapping files: " + ex.getMessage());
        }
        Logger.msg(1, String.format("Loaded [%d] maps from [%s]", loadedMapURLs.size(), mapURL));
    }

    public String marshall(Object obj) throws IOException, MappingException, MarshalException, ValidationException {
        if (obj == null) {
            return "<NULL/>";
        }
        if (obj instanceof Outcome) {
            return ((Outcome)obj).getData();
        }
        StringWriter sWriter = new StringWriter();
        Marshaller marshaller = this.mappingContext.createMarshaller();
        marshaller.setWriter((Writer)sWriter);
        marshaller.setMarshalAsDocument(false);
        if (obj instanceof Query) {
            marshaller.addProcessingInstruction("javax.xml.transform.disable-output-escaping", "");
        }
        marshaller.marshal(obj);
        return sWriter.toString();
    }

    public Object unmarshall(String data) throws IOException, MappingException, MarshalException, ValidationException {
        if (data.equals("<NULL/>")) {
            return null;
        }
        StringReader sReader = new StringReader(data);
        return this.mappingContext.createUnmarshaller().unmarshal((Reader)sReader);
    }
}

