/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import java.lang.ref.Reference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class TransientCache<K, V>
extends AbstractMap<K, V> {
    private Map<K, Reference<V>> map = new Hashtable<K, Reference<V>>();
    private transient Set<K> keySet = null;

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        Hashtable<K, V> newMap = new Hashtable<K, V>();
        Iterator<Map.Entry<K, Reference<V>>> iter = this.map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<K, Reference<V>> me = iter.next();
            Reference<V> ref = me.getValue();
            V o = ref.get();
            if (o == null) {
                iter.remove();
                continue;
            }
            newMap.put(me.getKey(), o);
        }
        return newMap.entrySet();
    }

    @Override
    public synchronized V put(K key, V value) {
        Reference<V> ref = this.makeReference(value);
        if ((ref = this.map.put(key, ref)) != null) {
            return ref.get();
        }
        return null;
    }

    public abstract Reference<V> makeReference(Object var1);

    @Override
    public V remove(Object key) {
        Map.Entry<K, Reference<Reference<V>>> e;
        Iterator<Map.Entry<K, Reference<V>>> i = this.map.entrySet().iterator();
        Map.Entry<K, Reference<Reference<V>>> correctEntry = null;
        if (key == null) {
            while (correctEntry == null && i.hasNext()) {
                e = i.next();
                if (e.getKey() != null) continue;
                correctEntry = e;
            }
        } else {
            while (correctEntry == null && i.hasNext()) {
                e = i.next();
                if (!key.equals(e.getKey())) continue;
                correctEntry = e;
            }
        }
        V oldValue = null;
        if (correctEntry != null) {
            Reference correctReference = (Reference)correctEntry.getValue();
            oldValue = (V)correctReference.get();
            i.remove();
        }
        return oldValue;
    }

    @Override
    public void clear() {
        this.map.entrySet().clear();
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public Iterator<K> iterator() {
                    return new Iterator<K>(){
                        private Iterator<Map.Entry<K, Reference<V>>> i;
                        {
                            this.i = TransientCache.this.map.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public K next() {
                            return this.i.next().getKey();
                        }

                        @Override
                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return TransientCache.this.size();
                }

                @Override
                public boolean contains(Object k) {
                    return TransientCache.this.containsKey(k);
                }
            };
        }
        return this.keySet;
    }
}

