/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle;

import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.graph.model.VertexOutlineCreator;
import org.cristalise.kernel.lifecycle.ActivityDef;
import org.cristalise.kernel.lifecycle.ActivitySlotDef;
import org.cristalise.kernel.lifecycle.instance.Activity;

public class LifecycleVertexOutlineCreator
implements VertexOutlineCreator {
    private static final int mActivityWidth = 130;
    private static final int mActivityHeight = 60;
    private static final int mSplitJoinWidth = 60;
    private static final int mSplitJoinHeight = 25;

    @Override
    public void setOutline(Vertex vertex) {
        GraphPoint centrePoint = vertex.getCentrePoint();
        GraphPoint[] outlinePoints = new GraphPoint[4];
        int vertexWidth = 0;
        int vertexHeight = 0;
        if (vertex instanceof Activity || vertex instanceof ActivitySlotDef || vertex instanceof ActivityDef) {
            vertexWidth = 130;
            vertexHeight = 60;
        } else {
            vertexWidth = 60;
            vertexHeight = 25;
        }
        outlinePoints[0] = new GraphPoint(centrePoint.x - vertexWidth / 2, centrePoint.y - vertexHeight / 2);
        outlinePoints[1] = new GraphPoint(centrePoint.x + vertexWidth / 2, centrePoint.y - vertexHeight / 2);
        outlinePoints[2] = new GraphPoint(centrePoint.x + vertexWidth / 2, centrePoint.y + vertexHeight / 2);
        outlinePoints[3] = new GraphPoint(centrePoint.x - vertexWidth / 2, centrePoint.y + vertexHeight / 2);
        vertex.setOutlinePoints(outlinePoints);
    }
}

