/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.collection.Aggregation;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionMember;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.collection.DependencyMember;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.Logger;

public abstract class PredefinedStepCollectionBase
extends PredefinedStep {
    protected String collectionName = null;
    protected int slotID = -1;
    protected ItemPath childPath = null;
    protected CastorHashMap memberNewProps = null;
    Collection<? extends CollectionMember> collection;

    protected void setChildPath(String data) throws InvalidItemPathException, ObjectNotFoundException {
        this.childPath = ItemPath.isUUID(data) ? new ItemPath(data) : new DomainPath(data).getItemPath();
    }

    protected Dependency getDependency() throws InvalidDataException {
        if (this.collection != null) {
            if (this.collection instanceof Dependency) {
                return (Dependency)this.collection;
            }
            String error = this.collectionName + " is not Dependency (class:" + this.collection.getClass().getSimpleName() + ")";
            Logger.error(error, new Object[0]);
            throw new InvalidDataException(error);
        }
        String error = "Collection '" + this.collectionName + "' was not found or not initilaised.";
        Logger.error(error, new Object[0]);
        throw new InvalidDataException(error);
    }

    protected Aggregation getAggregation() throws InvalidDataException {
        if (this.collection != null) {
            if (this.collection instanceof Aggregation) {
                return (Aggregation)this.collection;
            }
            String error = this.collectionName + " is not Aggregation (class:" + this.collection.getClass().getSimpleName() + ")";
            Logger.error(error, new Object[0]);
            throw new InvalidDataException(error);
        }
        String error = "Collection '" + this.collectionName + "' was not found or not initilaised.";
        Logger.error(error, new Object[0]);
        throw new InvalidDataException(error);
    }

    protected String[] unpackParamsAndGetCollection(ItemPath item, String requestData, Object locker) throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        Object[] params = PredefinedStepCollectionBase.getDataList(requestData);
        if (params == null || params.length < 2) {
            throw new InvalidDataException("CollectionBase - Invalid parameters:" + Arrays.toString(params));
        }
        Logger.msg(2, "PredefinedStepCollectionBase.unpackParamsAndGetCollection() - params:%s", Arrays.toString(params));
        this.collectionName = params[0];
        this.collection = (Collection)Gateway.getStorage().get(item, (Object)((Object)ClusterType.COLLECTION) + "/" + this.collectionName + "/last", locker);
        try {
            if (StringUtils.isNumeric((CharSequence)params[1])) {
                this.slotID = Integer.parseInt((String)params[1]);
                if (params.length > 2 && StringUtils.isNotBlank((CharSequence)params[2])) {
                    this.setChildPath((String)params[2]);
                }
                if (params.length > 3 && StringUtils.isNotBlank((CharSequence)params[3])) {
                    this.memberNewProps = (CastorHashMap)Gateway.getMarshaller().unmarshall((String)params[3]);
                }
            } else {
                this.setChildPath((String)params[1]);
                if (params.length > 2 && StringUtils.isNotBlank((CharSequence)params[2])) {
                    this.memberNewProps = (CastorHashMap)Gateway.getMarshaller().unmarshall((String)params[2]);
                }
            }
        }
        catch (Exception e) {
            Logger.error("CollectionBase - Invalid parameters:" + Arrays.toString(params), new Object[0]);
            Logger.error(e);
            throw new InvalidDataException("CollectionBase - Invalid parameters:" + Arrays.toString(params));
        }
        return params;
    }

    protected DependencyMember getDependencyMember() throws InvalidDataException, ObjectNotFoundException {
        List<CollectionMember> memberList = this.collection.resolveMembers(this.slotID, this.childPath);
        if (memberList.size() != 1) {
            throw new InvalidDataException(this.collectionName + "contains more the one member for slotID:" + this.slotID + " memberId:" + this.childPath);
        }
        CollectionMember member = memberList.get(0);
        if (!(member instanceof DependencyMember)) {
            throw new InvalidDataException(this.collectionName + " has to be Dependency (member class:" + member.getClass().getSimpleName() + ")");
        }
        return (DependencyMember)member;
    }
}

