/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.cristalise.kernel.process.Bootstrap;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.ShutdownHandler;
import org.cristalise.kernel.process.resource.BadArgumentsException;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.Logger;

public abstract class AbstractMain {
    public static boolean isServer = false;
    private static ShutdownHandler shutdownHandler;
    public static final String MAIN_ARG_NONEWLOGSTREAM = "noNewLogStream";
    public static final String MAIN_ARG_CONFIG = "config";
    public static final String MAIN_ARG_LOGLEVEL = "logLevel";
    public static final String MAIN_ARG_LOGFILE = "logFile";
    public static final String MAIN_ARG_CONNECT = "connect";
    public static final String MAIN_ARG_RESETIOR = "resetIOR";

    public static Properties readC2KArgs(String[] args) throws BadArgumentsException {
        String configPath;
        boolean wMustAddNewLogStream;
        Properties argProps = new Properties();
        int logLevel = 0;
        PrintStream logStream = System.out;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-") && args[i].length() > 1) {
                String key = args[i].substring(1);
                if (argProps.containsKey(key)) {
                    throw new BadArgumentsException("Argument " + args[i] + " given twice");
                }
                String value = "";
                if (args.length > i + 1 && !args[i + 1].startsWith("-")) {
                    value = args[++i];
                }
                argProps.put(key, value);
                continue;
            }
            throw new BadArgumentsException("Bad argument: " + args[i]);
        }
        if (argProps.containsKey(MAIN_ARG_LOGFILE)) {
            try {
                logStream = new PrintStream(new FileOutputStream(argProps.getProperty(MAIN_ARG_LOGFILE)), true);
                System.setErr(logStream);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new BadArgumentsException("Logfile " + argProps.getProperty(MAIN_ARG_LOGFILE) + " cannot be created");
            }
        }
        boolean bl = wMustAddNewLogStream = !argProps.contains(MAIN_ARG_NONEWLOGSTREAM);
        if (wMustAddNewLogStream) {
            if (argProps.containsKey(MAIN_ARG_LOGLEVEL)) {
                logLevel = Integer.parseInt(argProps.getProperty(MAIN_ARG_LOGLEVEL));
            }
            Logger.addLogStream(logStream, logLevel);
        }
        if (wMustAddNewLogStream) {
            Logger.msg("New logStream added at logLevel %d: %s", logLevel, logStream.getClass().getName());
        }
        if (Logger.doLog(3)) {
            Enumeration<?> e = argProps.propertyNames();
            while (e.hasMoreElements()) {
                String next = (String)e.nextElement();
                System.out.println("AbstractMain: Param " + next + ": " + argProps.getProperty(next));
            }
        }
        if ((configPath = argProps.getProperty(MAIN_ARG_CONFIG)) == null) {
            throw new BadArgumentsException("Config file not specified");
        }
        String connectFile = argProps.getProperty(MAIN_ARG_CONNECT);
        if (connectFile == null) {
            throw new BadArgumentsException("Connect file not specified");
        }
        Properties c2kProps = AbstractMain.readPropertyFiles(configPath, connectFile, argProps);
        Logger.msg(7, "AbstractMain.standardSetUp() - readC2KArgs() DONE.", new Object[0]);
        return c2kProps;
    }

    public static Properties readPropertyFiles(String configPath, String connectFile, Properties argProps) throws BadArgumentsException {
        try {
            Properties c2kProps = FileStringUtility.loadConfigFile(configPath);
            if (argProps != null) {
                c2kProps.putAll((Map<?, ?>)argProps);
            }
            FileStringUtility.appendConfigFile(c2kProps, connectFile);
            if (!c2kProps.containsKey("LocalCentre")) {
                String connectFileName = new File(connectFile).getName();
                String centreId = connectFileName.substring(0, connectFileName.lastIndexOf(".clc"));
                c2kProps.setProperty("LocalCentre", centreId);
            }
            if (argProps != null) {
                c2kProps.putAll((Map<?, ?>)argProps);
            }
            return c2kProps;
        }
        catch (IOException e) {
            Logger.error(e);
            throw new BadArgumentsException(e.getMessage());
        }
    }

    public static void setShutdownHandler(ShutdownHandler handler) {
        shutdownHandler = handler;
    }

    public static void shutdown(int errCode) {
        Bootstrap.abort();
        if (shutdownHandler != null) {
            shutdownHandler.shutdown(errCode, isServer);
        }
        try {
            Gateway.close();
        }
        catch (Exception ex) {
            Logger.error(ex);
        }
        throw new ThreadDeath();
    }
}

