/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import org.cristalise.kernel.process.AbstractMain;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.scripting.ScriptConsole;
import org.cristalise.kernel.utils.server.SimpleTCPIPServer;

public class Logger {
    private static int mHighestLogLevel = 0;
    private static long startTime = System.currentTimeMillis();
    private static HashMap<PrintStream, Integer> logStreams = new HashMap();
    protected static SimpleTCPIPServer mConsole = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printMessage(String message, int msgLogLevel, Object ... args) {
        HashMap<PrintStream, Integer> hashMap = logStreams;
        synchronized (hashMap) {
            if (logStreams.isEmpty()) {
                if (args.length == 0) {
                    System.out.println(message);
                } else {
                    System.out.println(String.format(message, args));
                }
            }
            Iterator<PrintStream> iter = logStreams.keySet().iterator();
            while (iter.hasNext()) {
                PrintStream element = iter.next();
                int logLevel = logStreams.get(element);
                if (logLevel > 9 && logLevel - 10 < msgLogLevel || msgLogLevel > 9 && logLevel < msgLogLevel - 10 || logLevel < 10 && msgLogLevel < 10 && logLevel < msgLogLevel) continue;
                if (logLevel > 9 || msgLogLevel > 9) {
                    message = Logger.reportTime() + " - " + message;
                }
                try {
                    if (args.length == 0) {
                        element.println(message);
                    } else {
                        element.println(String.format(message, args));
                    }
                    element.flush();
                }
                catch (Exception ex) {
                    iter.remove();
                }
            }
        }
    }

    private static String reportTime() {
        long now = System.currentTimeMillis();
        Timestamp ts = new Timestamp(now);
        double since = (double)(now - startTime) / 1000.0;
        return ts.toString() + " (" + since + "s)";
    }

    private static void printMessage(Throwable ex) {
        StringWriter msgString = new StringWriter();
        PrintWriter msg = new PrintWriter(msgString);
        msg.print(ex instanceof Exception ? "EXCEPTION:" : "JVM ERROR:");
        ex.printStackTrace(msg);
        Logger.printMessage(msgString.toString(), 0, new Object[0]);
    }

    public static boolean doLog(int logLevel) {
        if (logLevel > 9) {
            logLevel -= 10;
        }
        return mHighestLogLevel >= logLevel;
    }

    @Deprecated
    public static void debug(String msg) {
        Logger.msg("DEBUG  : " + msg, new Object[0]);
    }

    public static void debug(int level, String msg, Object ... args) {
        Logger.msg(level, "DEBUG  : " + msg, args);
    }

    public static void msg(int level, String msg, Object ... args) {
        Logger.printMessage(msg, level, args);
    }

    public static void msg(String msg, Object ... args) {
        Logger.printMessage(msg, 0, args);
    }

    public static void error(String msg, Object ... args) {
        Logger.printMessage("ERROR  : " + msg, 0, args);
    }

    public static void error(Throwable ex) {
        Logger.printMessage(ex);
    }

    public static void warning(String msg, Object ... args) {
        Logger.printMessage("WARNING: " + msg, 0, args);
    }

    public static void die(String msg, Object ... args) {
        Logger.printMessage("FATAL  : " + msg, 0, args);
        AbstractMain.shutdown(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLogStream(PrintStream console, int logLevel) {
        try {
            console.println("***********************************************************");
            console.println("  CRISTAL log started at level " + logLevel + " @" + new Timestamp(System.currentTimeMillis()).toString());
            console.println("***********************************************************");
        }
        catch (Exception ex) {
            System.out.println("Exception accessing log stream");
            ex.printStackTrace();
        }
        HashMap<PrintStream, Integer> hashMap = logStreams;
        synchronized (hashMap) {
            int thisLogLevel;
            logStreams.put(console, logLevel);
            int n = thisLogLevel = logLevel > 9 ? logLevel - 10 : logLevel;
            if (thisLogLevel > mHighestLogLevel) {
                mHighestLogLevel = thisLogLevel;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLogStream(PrintStream console) {
        HashMap<PrintStream, Integer> hashMap = logStreams;
        synchronized (hashMap) {
            Integer logIntObj = logStreams.get(console);
            if (logIntObj == null) {
                return;
            }
            int logLevel = logIntObj;
            logStreams.remove(console);
            if (logLevel == mHighestLogLevel || logLevel > 9 && logLevel - 10 == mHighestLogLevel) {
                mHighestLogLevel = 0;
                for (Integer element : logStreams.values()) {
                    int thisLogLevel = element > 9 ? element - 10 : element;
                    if (thisLogLevel <= mHighestLogLevel) continue;
                    mHighestLogLevel = thisLogLevel;
                }
            }
        }
    }

    public static int initConsole(String id) {
        int port = Gateway.getProperties().getInt(id + ".Console.port", 0);
        if (port == 0) {
            Logger.msg("No port defined for " + id + " console. Using any port.", new Object[0]);
        }
        mConsole = new SimpleTCPIPServer(port, ScriptConsole.class, 5);
        mConsole.startListening();
        Gateway.getProperties().setProperty(id + ".Console.port", String.valueOf(mConsole.getPort()));
        return mConsole.getPort();
    }

    public static int getConsolePort() {
        return mConsole.getPort();
    }

    public static void closeConsole() {
        if (mConsole != null) {
            mConsole.stopListening();
        }
        mConsole = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAll() {
        HashMap<PrintStream, Integer> hashMap = logStreams;
        synchronized (hashMap) {
            logStreams.clear();
            mHighestLogLevel = 0;
        }
    }
}

