/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.persistency.outcome;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.utils.DescriptionObject;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.Logger;
import org.exolab.castor.xml.schema.reader.SchemaReader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Schema
implements DescriptionObject,
ErrorHandler {
    private String name;
    private Integer version;
    private final String schemaData;
    private ItemPath itemPath;
    protected StringBuffer errors = null;
    public org.exolab.castor.xml.schema.Schema som = null;

    public Schema(String name, int version, ItemPath itemPath, String schema) {
        this.name = name;
        this.version = version;
        this.itemPath = itemPath;
        this.schemaData = schema;
    }

    public Schema(String name, int version, String schema) {
        this.name = name;
        this.version = version;
        this.schemaData = schema;
        this.itemPath = null;
    }

    public Schema(String schema) {
        this.schemaData = schema;
        this.name = "Schema";
        this.version = 0;
    }

    public String getXSD() {
        return this.getSchemaData();
    }

    public org.exolab.castor.xml.schema.Schema getSom() {
        if (this.som == null && StringUtils.isNotBlank((CharSequence)this.schemaData)) {
            try {
                this.som = new SchemaReader(new InputSource(new StringReader(this.schemaData))).read();
            }
            catch (IOException e) {
                Logger.error(e);
            }
        }
        return this.som;
    }

    public synchronized String validate() throws IOException {
        this.errors = new StringBuffer();
        SchemaReader mySchemaReader = new SchemaReader(new InputSource(new StringReader(this.schemaData)));
        mySchemaReader.setErrorHandler((ErrorHandler)this);
        mySchemaReader.setValidation(true);
        this.som = mySchemaReader.read();
        return this.errors.toString();
    }

    @Override
    public String getItemID() {
        if (this.itemPath == null || this.itemPath == null || this.itemPath.getUUID() == null) {
            return "";
        }
        return this.itemPath.getUUID().toString();
    }

    private void appendError(String level, Exception ex) {
        this.errors.append(level);
        String message = ex.getMessage();
        if (message == null || message.length() == 0) {
            message = ex.getClass().getName();
        }
        this.errors.append(message);
        this.errors.append("\n");
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        this.appendError("ERROR: ", ex);
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        this.appendError("FATAL: ", ex);
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        this.appendError("WARNING: ", ex);
    }

    @Override
    public CollectionArrayList makeDescCollections() {
        return new CollectionArrayList();
    }

    @Override
    public void export(Writer imports, File dir, boolean shallow) throws IOException {
        String fileName = this.getName() + (this.getVersion() == null ? "" : "_" + this.getVersion()) + ".xsd";
        String typeCode = BuiltInResources.SCHEMA_RESOURCE.getTypeCode();
        FileStringUtility.string2File(new File(new File(dir, typeCode), fileName), this.schemaData);
        if (imports == null) {
            return;
        }
        if (Gateway.getProperties().getBoolean("Resource.useOldImportFormat", false)) {
            imports.write("<Resource name='" + this.getName() + "' " + (this.getItemPath() == null ? "" : "id='" + this.getItemID() + "' ") + (this.getVersion() == null ? "" : "version='" + this.getVersion() + "' ") + "type='" + typeCode + "'>boot/" + typeCode + "/" + fileName + "</Resource>\n");
        } else {
            imports.write("<SchemaResource name='" + this.getName() + "' " + (this.getItemPath() == null ? "" : "id='" + this.getItemID() + "' ") + (this.getVersion() == null ? "" : "version='" + this.getVersion() + "'") + "/>\n");
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.name.equals(((Schema)obj).getName()) && this.version == ((Schema)obj).getVersion();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    public String getSchemaData() {
        return this.schemaData;
    }

    @Override
    public ItemPath getItemPath() {
        return this.itemPath;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setVersion(Integer version) {
        this.version = version;
    }

    @Override
    public void setItemPath(ItemPath itemPath) {
        this.itemPath = itemPath;
    }
}

