/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle;

import java.util.Vector;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.graph.traversal.GraphTraversal;
import org.cristalise.kernel.lifecycle.LoopDef;
import org.cristalise.kernel.lifecycle.WfVertexDef;
import org.cristalise.kernel.lifecycle.instance.AndSplit;
import org.cristalise.kernel.lifecycle.instance.WfVertex;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.utils.LocalObjectLoader;

public class AndSplitDef
extends WfVertexDef {
    public AndSplitDef() {
        this.mErrors = new Vector(0, 1);
        this.setBuiltInProperty(BuiltInVertexProperties.ROUTING_SCRIPT_NAME, "");
        this.setBuiltInProperty(BuiltInVertexProperties.ROUTING_SCRIPT_VERSION, "");
        this.setBuiltInProperty(BuiltInVertexProperties.ROUTING_EXPR, "");
    }

    @Override
    public boolean verify() {
        this.mErrors.removeAllElements();
        boolean err = true;
        int nbInEdges = this.getInEdges().length;
        if (nbInEdges == 0 && this.getID() != this.getParent().getChildrenGraphModel().getStartVertexId()) {
            this.mErrors.add("Unreachable");
            err = false;
        } else if (nbInEdges > 1) {
            this.mErrors.add("Bad nb of previous");
            err = false;
        } else if (this.getOutEdges().length <= 1) {
            this.mErrors.add("not enough next");
            err = false;
        } else if (!(this instanceof LoopDef)) {
            Vertex[] outV = this.getOutGraphables();
            Vertex[] anteVertices = GraphTraversal.getTraversal(this.getParent().getChildrenGraphModel(), this, 1, false);
            boolean loop = false;
            boolean errInLoop = true;
            for (int i = 0; i < outV.length; ++i) {
                for (int j = 0; j < anteVertices.length; ++j) {
                    if (loop || outV[i].getID() != anteVertices[j].getID()) continue;
                    if (outV[i] instanceof LoopDef) {
                        loop = true;
                        j = anteVertices.length;
                        i = outV.length;
                        continue;
                    }
                    errInLoop = false;
                }
            }
            if (errInLoop && loop) {
                this.mErrors.add("Problem in Loop");
                err = false;
            }
        }
        return err;
    }

    @Override
    public boolean loop() {
        boolean loop2 = false;
        if (!this.loopTested) {
            this.loopTested = true;
            if (this.getOutGraphables().length != 0) {
                Vertex[] outVertices = this.getOutGraphables();
                for (int i = 0; i < outVertices.length; ++i) {
                    WfVertexDef tmp = (WfVertexDef)this.getOutGraphables()[i];
                    loop2 = loop2 || tmp.loop();
                }
            }
        }
        this.loopTested = false;
        return loop2;
    }

    @Override
    public WfVertex instantiate() throws InvalidDataException, ObjectNotFoundException {
        AndSplit newSplit = new AndSplit();
        this.configureInstance(newSplit);
        return newSplit;
    }

    public Script getRoutingScript() throws ObjectNotFoundException, InvalidDataException {
        Integer scriptVersion;
        String scriptName = (String)this.getBuiltInProperty(BuiltInVertexProperties.ROUTING_SCRIPT_NAME);
        try {
            String scriptVerStr = (String)this.getBuiltInProperty(BuiltInVertexProperties.ROUTING_SCRIPT_VERSION);
            if (scriptVerStr == null || scriptVerStr.isEmpty()) {
                throw new ObjectNotFoundException();
            }
            scriptVersion = Integer.valueOf(scriptVerStr.toString());
        }
        catch (NumberFormatException e) {
            throw new InvalidDataException(e.getMessage());
        }
        return LocalObjectLoader.getScript(scriptName, scriptVersion);
    }
}

