/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterStorage;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.auth.Authenticator;
import org.cristalise.kernel.querying.Query;
import org.cristalise.kernel.utils.Logger;

public class MemoryOnlyClusterStorage
extends ClusterStorage {
    HashMap<ItemPath, Map<String, C2KLocalObject>> memoryCache = new HashMap();

    public void clear() {
        this.memoryCache.clear();
    }

    @Override
    public void open(Authenticator auth) throws PersistencyException {
    }

    @Override
    public void close() throws PersistencyException {
    }

    @Override
    public boolean checkQuerySupport(String language) {
        Logger.warning("MemoryOnlyClusterStorage DOES NOT Support any query", new Object[0]);
        return false;
    }

    @Override
    public short queryClusterSupport(String clusterType) {
        return 3;
    }

    @Override
    public String getName() {
        return "Memory Cache";
    }

    @Override
    public String getId() {
        return "Memory Cache";
    }

    @Override
    public String executeQuery(Query query) throws PersistencyException {
        throw new PersistencyException("UNIMPLEMENTED funnction");
    }

    @Override
    public C2KLocalObject get(ItemPath thisItem, String path) throws PersistencyException {
        Map<String, C2KLocalObject> sysKeyMemCache = this.memoryCache.get(thisItem);
        if (sysKeyMemCache != null) {
            return sysKeyMemCache.get(path);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(ItemPath thisItem, C2KLocalObject obj) throws PersistencyException {
        Map<Object, Object> sysKeyMemCache;
        HashMap<ItemPath, Map<String, C2KLocalObject>> hashMap = this.memoryCache;
        synchronized (hashMap) {
            if (this.memoryCache.containsKey(thisItem)) {
                sysKeyMemCache = this.memoryCache.get(thisItem);
            } else {
                sysKeyMemCache = new HashMap();
                this.memoryCache.put(thisItem, sysKeyMemCache);
            }
        }
        String path = ClusterStorage.getPath(obj);
        Map<Object, Object> map = sysKeyMemCache;
        synchronized (map) {
            sysKeyMemCache.put(path, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(ItemPath thisItem, String path) throws PersistencyException {
        Map<String, C2KLocalObject> sysKeyMemCache = this.memoryCache.get(thisItem);
        if (sysKeyMemCache != null) {
            Map<String, C2KLocalObject> map = sysKeyMemCache;
            synchronized (map) {
                if (sysKeyMemCache.containsKey(path)) {
                    sysKeyMemCache.remove(path);
                    if (sysKeyMemCache.isEmpty()) {
                        HashMap<ItemPath, Map<String, C2KLocalObject>> hashMap = this.memoryCache;
                        synchronized (hashMap) {
                            this.memoryCache.remove(thisItem);
                        }
                    }
                }
            }
        }
    }

    @Override
    public String[] getClusterContents(ItemPath thisItem, String path) throws PersistencyException {
        Map<String, C2KLocalObject> sysKeyMemCache = this.memoryCache.get(thisItem);
        ArrayList<String> result = new ArrayList<String>();
        if (sysKeyMemCache != null) {
            while (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            path = path + "/";
            for (String thisPath : sysKeyMemCache.keySet()) {
                String end;
                int slash;
                String suffix;
                if (!thisPath.startsWith(path) || result.contains(suffix = (slash = (end = thisPath.substring(path.length())).indexOf(47)) > -1 ? end.substring(0, slash) : end)) continue;
                result.add(suffix);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] getClusterContents(ItemPath itemPath, ClusterType type) throws PersistencyException {
        return this.getClusterContents(itemPath, type.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpContents(ItemPath thisItem) {
        HashMap<ItemPath, Map<String, C2KLocalObject>> hashMap = this.memoryCache;
        synchronized (hashMap) {
            Logger.msg(0, "Cached Objects of Entity " + thisItem, new Object[0]);
            Map<String, C2KLocalObject> sysKeyMemCache = this.memoryCache.get(thisItem);
            if (sysKeyMemCache == null) {
                Logger.msg(0, "No cache found", new Object[0]);
                return;
            }
            try {
                Map<String, C2KLocalObject> map = sysKeyMemCache;
                synchronized (map) {
                    Iterator<String> iterator = sysKeyMemCache.keySet().iterator();
                    while (iterator.hasNext()) {
                        String name;
                        String path = name = iterator.next();
                        try {
                            Logger.msg(0, "    Path " + path + ": " + sysKeyMemCache.get(path).getClass().getName(), new Object[0]);
                        }
                        catch (NullPointerException e) {
                            Logger.msg(0, "    Path " + path + ": reaped", new Object[0]);
                        }
                    }
                }
            }
            catch (ConcurrentModificationException ex) {
                Logger.msg(0, "Cache modified - aborting", new Object[0]);
            }
        }
        Logger.msg(0, "Total number of cached entities: " + this.memoryCache.size(), new Object[0]);
    }
}

