/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;

public class RemoveViewpoint
extends PredefinedStep {
    public static final String description = "Removes a viewpoint from the Item";

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, ObjectNotFoundException, PersistencyException {
        Object[] params = RemoveViewpoint.getDataList(requestData);
        if (Logger.doLog(3)) {
            Logger.msg(3, "RemoveViewpoint: called by " + agent + " on " + item + " with parameters " + Arrays.toString(params), new Object[0]);
        }
        if (params.length != 2) {
            throw new InvalidDataException("RemoveViewpoint: Invalid parameters " + Arrays.toString(params));
        }
        String schemaName = params[0];
        String viewName = params[1];
        Gateway.getStorage().remove(item, (Object)((Object)ClusterType.VIEWPOINT) + "/" + schemaName + "/" + viewName, locker);
        return requestData;
    }
}

