/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined.server;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.storage.XMLClusterStorage;

public class BulkImport
extends PredefinedStep {
    public static final String BULK_IMPORT_ROOT_DIRECTORY = "BulkImport.rootDirectory";
    public static final String BULK_IMPORT_USE_DIRECTORIES = "BulkImport.useDirectories";
    public static final String BULK_IMPORT_FILE_EXTENSION = "BulkImport.fileExtension";
    private String root = Gateway.getProperties().getString("BulkImport.rootDirectory");
    private String ext = Gateway.getProperties().getString("BulkImport.fileExtension", "");
    private Boolean useDir = Gateway.getProperties().getBoolean("BulkImport.useDirectories", false);
    XMLClusterStorage importCluster;

    public void initialise() throws InvalidDataException {
        if (this.importCluster == null) {
            if (this.root == null) {
                throw new InvalidDataException("BulkImport.runActivityLogic() - Root path not given in config file.");
            }
            this.importCluster = new XMLClusterStorage(this.root, this.ext, this.useDir);
        }
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath itemPath, int transitionID, String requestData, Object locker) throws InvalidDataException, InvalidCollectionModification, ObjectAlreadyExistsException, ObjectCannotBeUpdated, ObjectNotFoundException, PersistencyException, CannotManageException {
        this.initialise();
        this.importAllClusters();
        return requestData;
    }

    public void importAllClusters() throws InvalidDataException, PersistencyException {
        for (ItemPath item : this.getItemsToImport(this.root)) {
            Object sublocker = new Object();
            block11: for (ClusterType type : this.importCluster.getClusters(item)) {
                switch (type) {
                    case PATH: {
                        this.importPath(item, sublocker);
                        continue block11;
                    }
                    case PROPERTY: {
                        this.importProperty(item, sublocker);
                        continue block11;
                    }
                    case LIFECYCLE: {
                        this.importLifeCycle(item, sublocker);
                        continue block11;
                    }
                    case HISTORY: {
                        this.importHistory(item, sublocker);
                        continue block11;
                    }
                    case VIEWPOINT: {
                        this.importViewPoint(item, sublocker);
                        continue block11;
                    }
                    case OUTCOME: {
                        this.importOutcome(item, sublocker);
                        continue block11;
                    }
                    case COLLECTION: {
                        this.importCollection(item, sublocker);
                        continue block11;
                    }
                    case JOB: {
                        this.importJob(item, sublocker);
                        continue block11;
                    }
                }
            }
            Gateway.getStorage().commit(sublocker);
        }
    }

    private List<ItemPath> getItemsToImport(String root) throws InvalidDataException {
        ArrayList<ItemPath> items = new ArrayList<ItemPath>();
        try {
            try (Stream<Path> files = Files.walk(Paths.get(root, new String[0]), new FileVisitOption[0]);){
                files.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(path -> {
                    try {
                        items.add(new ItemPath(path.getFileName().toString()));
                    }
                    catch (InvalidItemPathException e) {
                        Logger.warning("BulkImport.getItemsToImport() - Unvalid UUID for import directory:" + path.getFileName().toString(), new Object[0]);
                    }
                });
            }
            return items;
        }
        catch (IOException e) {
            Logger.error(e);
            throw new InvalidDataException(e.getMessage());
        }
    }

    public void importProperty(ItemPath item, Object locker) throws PersistencyException {
        String[] contents;
        for (String c : contents = this.importCluster.getClusterContents(item, ClusterType.PROPERTY)) {
            String path = (Object)((Object)ClusterType.PROPERTY) + "/" + c;
            C2KLocalObject prop = this.importCluster.get(item, path);
            Gateway.getStorage().put(item, prop, locker);
        }
    }

    public void importViewPoint(ItemPath item, Object locker) throws PersistencyException {
        String[] contents;
        for (String c : contents = this.importCluster.getClusterContents(item, ClusterType.VIEWPOINT)) {
            String[] subContents;
            for (String sc : subContents = this.importCluster.getClusterContents(item, (Object)((Object)ClusterType.VIEWPOINT) + "/" + c)) {
                String path = (Object)((Object)ClusterType.VIEWPOINT) + "/" + c + "/" + sc;
                C2KLocalObject view = this.importCluster.get(item, path);
                Gateway.getStorage().put(item, view, locker);
            }
        }
    }

    public void importLifeCycle(ItemPath item, Object locker) throws PersistencyException {
        String[] contents;
        for (String c : contents = this.importCluster.getClusterContents(item, ClusterType.LIFECYCLE)) {
            String path = (Object)((Object)ClusterType.LIFECYCLE) + "/" + c;
            C2KLocalObject wf = this.importCluster.get(item, path);
            Gateway.getStorage().put(item, wf, locker);
        }
    }

    public void importHistory(ItemPath item, Object locker) throws PersistencyException {
        String[] contents;
        for (String c : contents = this.importCluster.getClusterContents(item, ClusterType.HISTORY)) {
            String path = (Object)((Object)ClusterType.HISTORY) + "/" + c;
            C2KLocalObject obj = this.importCluster.get(item, path);
            Gateway.getStorage().put(item, obj, locker);
        }
    }

    public void importOutcome(ItemPath item, Object locker) throws PersistencyException {
        String[] schemas;
        for (String schema : schemas = this.importCluster.getClusterContents(item, ClusterType.OUTCOME)) {
            String[] versions;
            for (String version : versions = this.importCluster.getClusterContents(item, (Object)((Object)ClusterType.OUTCOME) + "/" + schema)) {
                String[] events;
                for (String event : events = this.importCluster.getClusterContents(item, (Object)((Object)ClusterType.OUTCOME) + "/" + schema + "/" + version)) {
                    C2KLocalObject obj = this.importCluster.get(item, (Object)((Object)ClusterType.OUTCOME) + "/" + schema + "/" + version + "/" + event);
                    Gateway.getStorage().put(item, obj, locker);
                }
            }
        }
    }

    public void importJob(ItemPath item, Object locker) throws PersistencyException {
        String[] contents;
        for (String c : contents = this.importCluster.getClusterContents(item, ClusterType.JOB)) {
            String path = (Object)((Object)ClusterType.JOB) + "/" + c;
            C2KLocalObject job = this.importCluster.get(item, path);
            Gateway.getStorage().put(item, job, locker);
        }
    }

    public void importCollection(ItemPath item, Object locker) throws PersistencyException {
        String[] names;
        for (String name : names = this.importCluster.getClusterContents(item, ClusterType.COLLECTION)) {
            String[] versions;
            for (String version : versions = this.importCluster.getClusterContents(item, (Object)((Object)ClusterType.COLLECTION) + "/" + name)) {
                C2KLocalObject coll = this.importCluster.get(item, (Object)((Object)ClusterType.COLLECTION) + "/" + name + "/" + version);
                Gateway.getStorage().put(item, coll, locker);
            }
        }
    }

    public void importDomainPath(ItemPath item, Object locker) throws PersistencyException {
        String[] domains;
        for (String name : domains = this.importCluster.getClusterContents(item, (Object)((Object)ClusterType.PATH) + "/Domain")) {
            try {
                Gateway.getLookupManager().add((DomainPath)this.importCluster.get(item, (Object)((Object)ClusterType.PATH) + "/Domain/" + name));
            }
            catch (CannotManageException | ObjectAlreadyExistsException | ObjectCannotBeUpdated e) {
                Logger.error((Throwable)e);
                throw new PersistencyException(e.getMessage());
            }
        }
    }

    public void importRolePath(ItemPath item, AgentPath agentPath, Object locker) throws PersistencyException {
        String[] roles;
        for (String role : roles = this.importCluster.getClusterContents(item, (Object)((Object)ClusterType.PATH) + "/Role")) {
            RolePath rolePath = (RolePath)this.importCluster.get(item, (Object)((Object)ClusterType.PATH) + "/Role/" + role);
            if (Gateway.getLookup().exists(rolePath)) continue;
            try {
                Gateway.getLookupManager().add(rolePath);
                if (agentPath == null) continue;
                Gateway.getLookupManager().addRole(agentPath, rolePath);
            }
            catch (CannotManageException | ObjectAlreadyExistsException | ObjectCannotBeUpdated | ObjectNotFoundException e) {
                Logger.error((Throwable)e);
                throw new PersistencyException(e.getMessage());
            }
        }
    }

    public ItemPath importItemPath(ItemPath item, Object locker) throws PersistencyException {
        try {
            ItemPath itemPath = (ItemPath)this.importCluster.get(item, (Object)((Object)ClusterType.PATH) + "/Item");
            Gateway.getLookupManager().add(itemPath);
            return itemPath;
        }
        catch (CannotManageException | ObjectAlreadyExistsException | ObjectCannotBeUpdated e) {
            Logger.error((Throwable)e);
            throw new PersistencyException(e.getMessage());
        }
    }

    public AgentPath importAgentPath(ItemPath item, Object locker) throws PersistencyException {
        try {
            AgentPath agentPath = (AgentPath)this.importCluster.get(item, (Object)((Object)ClusterType.PATH) + "/Item");
            Gateway.getLookupManager().add(agentPath);
            Gateway.getLookupManager().setAgentPassword(agentPath, "aaa");
            return agentPath;
        }
        catch (NoSuchAlgorithmException | CannotManageException | ObjectAlreadyExistsException | ObjectCannotBeUpdated | ObjectNotFoundException e) {
            Logger.error((Throwable)e);
            throw new PersistencyException(((Throwable)e).getMessage());
        }
    }

    public void importPath(ItemPath item, Object locker) throws PersistencyException {
        String[] contents = this.importCluster.getClusterContents(item, ClusterType.PATH);
        AgentPath agentPath = null;
        String entity = "";
        if (Arrays.asList(contents).contains("Item")) {
            entity = "Item";
        }
        if (Arrays.asList(contents).contains("Agent")) {
            entity = "Agent";
        }
        if (StringUtils.isNotBlank((CharSequence)entity)) {
            if (entity.equals("Item")) {
                this.importItemPath(item, locker);
            } else if (entity.equals("Agent")) {
                agentPath = this.importAgentPath(item, locker);
            }
        } else {
            Logger.warning("BulkImport.importPath() - WARNING: '" + item + "' has no Path.Item or Path.Agent files", new Object[0]);
        }
        for (String c : contents) {
            if (c.equals("Domain")) {
                this.importDomainPath(item, locker);
                continue;
            }
            if (!c.equals("Role")) continue;
            this.importRolePath(item, agentPath, locker);
        }
    }
}

