/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.routingHelpers;

import javax.xml.xpath.XPathExpressionException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lifecycle.routingHelpers.DataHelper;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;

public class ViewpointDataHelper
implements DataHelper {
    @Override
    public String get(ItemPath itemPath, String actContext, String dataPath, Object locker) throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        String[] paths = dataPath.split(":");
        if (paths.length != 2) {
            throw new InvalidDataException("Invalid path: '" + dataPath + "' should have only one colon (:)");
        }
        String viewpoint = paths[0];
        String xpath = paths[1];
        if (viewpoint.startsWith("./")) {
            Logger.warning("Removing leading dot on viewpoint data helper path at " + actContext + " in " + itemPath.getUUID().toString() + ". Definition should be migrated.", new Object[0]);
            viewpoint = viewpoint.substring(2);
        }
        Viewpoint view = (Viewpoint)Gateway.getStorage().get(itemPath, (Object)((Object)ClusterType.VIEWPOINT) + "/" + viewpoint, locker);
        Outcome outcome = view.getOutcome(locker);
        try {
            return outcome.getFieldByXPath(xpath);
        }
        catch (XPathExpressionException e) {
            throw new InvalidDataException("Invalid XPath: " + xpath);
        }
    }
}

