/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lookup;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.SystemKey;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;
import org.omg.CORBA.Object;

public class ItemPath
extends Path {
    protected String mIOR;

    public ItemPath() {
        this.setSysKey(UUID.randomUUID());
    }

    public ItemPath(UUID uuid, String ior) {
        this.setSysKey(uuid);
        this.setIORString(ior);
    }

    public ItemPath(UUID uuid) {
        this.setSysKey(uuid);
    }

    public ItemPath(SystemKey syskey) {
        this.setSysKey(syskey);
    }

    public ItemPath(String[] path) throws InvalidItemPathException {
        super(path);
        this.checkSysKeyFromPath();
    }

    public ItemPath(String path) throws InvalidItemPathException {
        super(path);
        if (path == null) {
            throw new InvalidItemPathException("Path cannot be null");
        }
        this.checkSysKeyFromPath();
    }

    @Override
    public void setPath(String[] path) {
        super.setPath(path);
    }

    @Override
    public void setPath(String path) {
        super.setPath(path);
    }

    @Override
    public void setPath(Path path) {
        super.setPath(path);
    }

    private void checkSysKeyFromPath() throws InvalidItemPathException {
        if (this.mPath.length == 1) {
            try {
                this.getUUID();
            }
            catch (Throwable ex) {
                throw new InvalidItemPathException(this.mPath[0] + " is not a valid UUID : " + ex.getMessage());
            }
        } else {
            throw new InvalidItemPathException("Not a valid item path: " + Arrays.toString(this.mPath));
        }
    }

    @Override
    public String getRoot() {
        return "entity";
    }

    @Override
    public ItemPath getItemPath() throws ObjectNotFoundException {
        return this;
    }

    @Override
    public Object getIOR() {
        if (this.mIOR == null) {
            try {
                this.mIOR = Gateway.getLookup().getIOR(this);
            }
            catch (ObjectNotFoundException ex) {
                Logger.warning(ex.getMessage(), new java.lang.Object[0]);
                return null;
            }
        }
        return Gateway.getORB().string_to_object(this.mIOR);
    }

    @Override
    public void setIOR(Object IOR) {
        this.mIOR = Gateway.getORB().object_to_string(IOR);
    }

    public String getIORString() {
        return this.mIOR;
    }

    public void setIORString(String ior) {
        this.mIOR = ior;
    }

    public byte[] getOID() {
        UUID uuid = this.getUUID();
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    protected void setSysKey(UUID uuid) {
        this.setPathFromUUID(uuid);
    }

    protected void setSysKey(SystemKey sysKey) {
        this.setPathFromUUID(new UUID(sysKey.msb, sysKey.lsb));
    }

    private void setPathFromUUID(UUID uuid) {
        this.mPath = new String[1];
        this.mPath[0] = uuid.toString();
    }

    @Override
    public SystemKey getSystemKey() {
        UUID uuid = this.getUUID();
        return new SystemKey(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    @Override
    public UUID getUUID() {
        return UUID.fromString(this.mPath[0]);
    }

    @Override
    public String getName() {
        return this.getUUID().toString();
    }

    @Override
    public String getClusterPath() {
        return (java.lang.Object)((java.lang.Object)ClusterType.PATH) + "/Item";
    }

    public static boolean isUUID(String entityKey) {
        if (entityKey.startsWith("/entity/")) {
            entityKey = entityKey.substring(8);
        }
        return entityKey.matches("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$");
    }
}

