/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.lifecycle.CompositeActivityDef;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.Workflow;
import org.cristalise.kernel.lifecycle.instance.predefined.server.ServerPredefinedStepContainer;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.LookupManager;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.process.resource.ResourceImportHandler;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.property.PropertyDescription;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.scripting.ScriptConsole;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;

public class Bootstrap {
    static DomainPath thisServerPath;
    static HashMap<String, AgentProxy> systemAgents;
    public static boolean shutdown;
    static StateMachine predefSM;

    public static StateMachine getPredefSM() throws ObjectNotFoundException, InvalidDataException {
        if (predefSM == null) {
            predefSM = LocalObjectLoader.getStateMachine("PredefinedStep", 0);
        }
        return predefSM;
    }

    public static void init() throws Exception {
        Bootstrap.getPredefSM();
        Bootstrap.checkAdminAgents();
        Bootstrap.createServerItem();
    }

    public static void run() throws Exception {
        Bootstrap.init();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.currentThread().setName("Bootstrapper");
                    Logger.msg("Bootstrap.run() - Bootstrapper started", new Object[0]);
                    ClassLoader wClassLoader = Bootstrap.class.getClassLoader();
                    Logger.msg("Bootstrap.run() setContextClassLoader=[%s]", wClassLoader);
                    Thread.currentThread().setContextClassLoader(wClassLoader);
                    if (!shutdown) {
                        Logger.msg("Bootstrap.run() - Verifying kernel boot data items", new Object[0]);
                        Bootstrap.verifyBootDataItems();
                    }
                    if (!shutdown) {
                        Logger.msg("Bootstrap.run() - Initialising Server Item Workflow", new Object[0]);
                        Bootstrap.initServerItemWf();
                    }
                    if (!shutdown) {
                        Gateway.getModuleManager().setUser(systemAgents.get("system"));
                        Gateway.getModuleManager().registerModules();
                    }
                    if (!shutdown) {
                        Logger.msg("Bootstrap.run() - Bootstrapper complete", new Object[0]);
                        Gateway.getModuleManager().runScripts("initialized");
                    }
                }
                catch (Throwable e) {
                    Logger.error(e);
                    Logger.die("Exception performing bootstrap. Check that everything is OK.", new Object[0]);
                }
            }
        }).start();
    }

    public static void abort() {
        shutdown = true;
    }

    public static void verifyBootDataItems() throws Exception {
        Logger.msg(1, "Bootstrap.verifyBootDataItems() - Start checking kernel descriptions ...", new Object[0]);
        String bootItems = FileStringUtility.url2String(Gateway.getResource().getKernelResourceURL("boot/allbootitems.txt"));
        Bootstrap.verifyBootDataItems(bootItems, null, true);
        Logger.msg(1, "Bootstrap.verifyBootDataItems() - DONE.", new Object[0]);
    }

    private static void verifyBootDataItems(String bootList, String ns, boolean reset) throws InvalidItemPathException {
        StringTokenizer str = new StringTokenizer(bootList, "\n\r");
        while (str.hasMoreTokens() && !shutdown) {
            String thisItem = str.nextToken();
            String[] idFilename = thisItem.split(",");
            String id = idFilename[0];
            String filename = idFilename[1];
            ItemPath itemPath = new ItemPath(id);
            String[] fileParts = filename.split("/");
            String itemType = fileParts[0];
            String itemName = fileParts[1];
            try {
                String location = "boot/" + filename + (itemType.equals("OD") ? ".xsd" : ".xml");
                Bootstrap.verifyResource(ns, itemName, 0, itemType, itemPath, location, reset);
            }
            catch (Exception e) {
                Logger.error(e);
                Logger.die("Error importing bootstrap items. Unsafe to continue.", new Object[0]);
            }
        }
    }

    public static DomainPath createResource(String ns, String itemName, int version, String itemType, Set<Outcome> outcomes, boolean reset) throws Exception {
        return Bootstrap.verifyResource(ns, itemName, version, itemType, null, outcomes, null, reset);
    }

    public static DomainPath verifyResource(String ns, String itemName, int version, String itemType, ItemPath itemPath, String dataLocation, boolean reset) throws Exception {
        return Bootstrap.verifyResource(ns, itemName, version, itemType, itemPath, null, dataLocation, reset);
    }

    public static DomainPath verifyResource(String ns, String itemName, int version, String itemType, ItemPath itemPath, Set<Outcome> outcomes, boolean reset) throws Exception {
        return Bootstrap.verifyResource(ns, itemName, version, itemType, itemPath, outcomes, null, reset);
    }

    private static DomainPath verifyResource(String ns, String itemName, int version, String itemType, ItemPath itemPath, Set<Outcome> outcomes, String dataLocation, boolean reset) throws Exception {
        ItemProxy thisProxy;
        ResourceImportHandler typeImpHandler = Gateway.getResourceImportHandler(BuiltInResources.getValue(itemType));
        Logger.msg(1, "Bootstrap.verifyResource() - Verifying " + typeImpHandler.getName() + " " + itemName + " v" + version, new Object[0]);
        DomainPath modDomPath = typeImpHandler.getPath(itemName, ns);
        if (modDomPath.exists()) {
            Logger.msg(3, "Bootstrap.verifyResource() - Found " + typeImpHandler.getName() + " " + itemName + ".", new Object[0]);
            thisProxy = Bootstrap.verifyPathAndModuleProperty(ns, itemType, itemName, itemPath, modDomPath, modDomPath);
        } else {
            if (itemPath == null) {
                itemPath = new ItemPath();
            }
            Logger.msg("Bootstrap.verifyResource() - " + typeImpHandler.getName() + " " + itemName + " not found. Creating new.", new Object[0]);
            thisProxy = Bootstrap.createResourceItem(typeImpHandler, itemName, ns, itemPath);
        }
        if (outcomes == null || outcomes.size() == 0) {
            outcomes = typeImpHandler.getResourceOutcomes(itemName, ns, dataLocation, version);
        }
        if (outcomes.size() == 0) {
            Logger.warning("Bootstrap.verifyResource() - no Outcome found therefore nothing stored!", new Object[0]);
        }
        for (Outcome newOutcome : outcomes) {
            if (!Bootstrap.checkToStoreOutcomeVersion(thisProxy, newOutcome, version, reset)) continue;
            if (ns != null) {
                newOutcome.validateAndCheck();
            }
            Bootstrap.storeOutcomeEventAndViews(thisProxy, newOutcome, version);
            CollectionArrayList cols = typeImpHandler.getCollections(itemName, version, newOutcome);
            for (Collection col : cols.list) {
                Gateway.getStorage().put(thisProxy.getPath(), col, thisProxy);
                Gateway.getStorage().clearCache(thisProxy.getPath(), (Object)((Object)ClusterType.COLLECTION) + "/" + col.getName());
                col.setVersion(null);
                Gateway.getStorage().put(thisProxy.getPath(), col, thisProxy);
            }
        }
        Gateway.getStorage().commit(thisProxy);
        return modDomPath;
    }

    private static ItemProxy verifyPathAndModuleProperty(String ns, String itemType, String itemName, ItemPath itemPath, DomainPath modDomPath, DomainPath path) throws Exception {
        LookupManager lookupManager = Gateway.getLookupManager();
        ItemProxy thisProxy = Gateway.getProxyManager().getProxy(path);
        if (itemPath != null && !path.getItemPath().equals(itemPath)) {
            Logger.warning("Resource " + itemType + "/" + itemName + " should have path " + itemPath + " but was found with path " + path.getItemPath(), new Object[0]);
            itemPath = path.getItemPath();
        }
        if (itemPath == null) {
            itemPath = path.getItemPath();
        }
        String moduleName = ns == null ? "kernel" : ns;
        try {
            String itemModule = thisProxy.getProperty("Module");
            if (!(itemModule == null || itemModule.equals("") || itemModule.equals("null") || moduleName.equals(itemModule))) {
                String error = "Module clash! Resource '" + itemName + "' included in module " + moduleName + " but is assigned to '" + itemModule + "'.";
                Logger.error(error, new Object[0]);
                throw new InvalidDataException(error);
            }
        }
        catch (ObjectNotFoundException ex) {
            String itemModule = "";
        }
        if (!modDomPath.equals(path)) {
            Logger.msg("Module item " + itemName + " found with path " + path.toString() + ". Moving to " + modDomPath.toString(), new Object[0]);
            modDomPath.setItemPath(itemPath);
            if (!modDomPath.exists()) {
                lookupManager.add(modDomPath);
            }
            lookupManager.delete(path);
        }
        return thisProxy;
    }

    private static void storeOutcomeEventAndViews(ItemProxy item, Outcome newOutcome, int version) throws PersistencyException, ObjectNotFoundException, InvalidDataException {
        Logger.msg("Bootstrap.storeOutcomeEventAndViews() - Writing new " + newOutcome.getSchema().getName() + " v" + version + " to " + item.getName(), new Object[0]);
        History hist = new History(item.getPath(), item);
        String viewName = String.valueOf(version);
        int eventID = hist.addEvent(systemAgents.get("system").getPath(), null, "Admin", "Bootstrap", "Bootstrap", "Bootstrap", newOutcome.getSchema(), Bootstrap.getPredefSM(), 0, viewName).getID();
        newOutcome.setID(eventID);
        Viewpoint newLastView = new Viewpoint(item.getPath(), newOutcome.getSchema(), "last", eventID);
        Viewpoint newNumberView = new Viewpoint(item.getPath(), newOutcome.getSchema(), viewName, eventID);
        Gateway.getStorage().put(item.getPath(), newOutcome, item);
        Gateway.getStorage().put(item.getPath(), newLastView, item);
        Gateway.getStorage().put(item.getPath(), newNumberView, item);
    }

    private static boolean checkToStoreOutcomeVersion(ItemProxy item, Outcome newOutcome, int version, boolean reset) throws PersistencyException, InvalidDataException, ObjectNotFoundException {
        Schema schema = newOutcome.getSchema();
        try {
            Viewpoint currentData = (Viewpoint)item.getObject((Object)((Object)ClusterType.VIEWPOINT) + "/" + newOutcome.getSchema().getName() + "/" + version);
            if (newOutcome.isIdentical(currentData.getOutcome())) {
                Logger.msg(5, "Bootstrap.checkToStoreOutcomeVersion() - Data identical, no update required", new Object[0]);
                return false;
            }
            if (!reset && !currentData.getEvent().getStepPath().equals("Bootstrap")) {
                Logger.msg("Bootstrap.checkToStoreOutcomeVersion() - Version " + version + " was not set by Bootstrap, and reset not requested. Not overwriting.", new Object[0]);
                return false;
            }
        }
        catch (ObjectNotFoundException ex) {
            Logger.msg("Bootstrap.checkToStoreOutcomeVersion() - " + schema.getName() + " " + item.getName() + " v" + version + " not found! Attempting to insert new.", new Object[0]);
        }
        return true;
    }

    private static ItemProxy createResourceItem(ResourceImportHandler impHandler, String itemName, String ns, ItemPath itemPath) throws Exception {
        PropertyDescriptionList pdList = impHandler.getPropDesc();
        PropertyArrayList props = new PropertyArrayList();
        LookupManager lookupManager = Gateway.getLookupManager();
        for (int i = 0; i < pdList.list.size(); ++i) {
            PropertyDescription pd = (PropertyDescription)pdList.list.get(i);
            String propName = pd.getName();
            String propVal = pd.getDefaultValue();
            if (propName.equals(BuiltInItemProperties.NAME.toString())) {
                propVal = itemName;
            } else if (propName.equals(BuiltInItemProperties.MODULE.toString())) {
                propVal = ns == null ? "kernel" : ns;
            }
            props.list.add(new Property(propName, propVal, pd.getIsMutable()));
        }
        CompositeActivity ca = new CompositeActivity();
        try {
            ca = (CompositeActivity)((CompositeActivityDef)LocalObjectLoader.getActDef(impHandler.getWorkflowName(), 0)).instantiate();
        }
        catch (ObjectNotFoundException ex) {
            Logger.error((Throwable)((Object)ex));
            Logger.error("Module resource workflow " + impHandler.getWorkflowName() + " not found. Using empty.", new Object[0]);
        }
        Gateway.getCorbaServer().createItem(itemPath);
        lookupManager.add(itemPath);
        DomainPath newDomPath = impHandler.getPath(itemName, ns);
        newDomPath.setItemPath(itemPath);
        lookupManager.add(newDomPath);
        ItemProxy newItemProxy = Gateway.getProxyManager().getProxy(itemPath);
        newItemProxy.initialise(systemAgents.get("system").getPath(), props, ca, null);
        return newItemProxy;
    }

    private static AgentProxy checkAgent(String name, String pass, RolePath rolePath, String uuid) throws Exception {
        Logger.msg(1, "Bootstrap.checkAgent() - Checking for existence of '" + name + "' agent.", new Object[0]);
        LookupManager lookup = Gateway.getLookupManager();
        try {
            AgentProxy agentProxy = Gateway.getProxyManager().getAgentProxy(lookup.getAgentPath(name));
            systemAgents.put(name, agentProxy);
            Logger.msg(3, "Bootstrap.checkAgent() - Agent '" + name + "' found.", new Object[0]);
            return agentProxy;
        }
        catch (ObjectNotFoundException agentProxy) {
            Logger.msg("Bootstrap.checkAgent() - Agent '" + name + "' not found. Creating.", new Object[0]);
            try {
                AgentPath agentPath = new AgentPath(new ItemPath(uuid), name);
                Gateway.getCorbaServer().createAgent(agentPath);
                lookup.add(agentPath);
                if (StringUtils.isNotBlank((CharSequence)pass)) {
                    lookup.setAgentPassword(agentPath, pass);
                }
                Logger.msg("Bootstrap.checkAgent() - Assigning role '" + rolePath.getName() + "'", new Object[0]);
                Gateway.getLookupManager().addRole(agentPath, rolePath);
                Gateway.getStorage().put(agentPath, new Property(BuiltInItemProperties.NAME, name, true), null);
                Gateway.getStorage().put(agentPath, new Property(BuiltInItemProperties.TYPE, "Agent", false), null);
                AgentProxy agentProxy2 = Gateway.getProxyManager().getAgentProxy(agentPath);
                systemAgents.put(name, agentProxy2);
                return agentProxy2;
            }
            catch (Exception ex) {
                Logger.error("Unable to create '" + name + "' Agent.", new Object[0]);
                throw ex;
            }
        }
    }

    public static void checkAdminAgents() throws Exception {
        RolePath adminRole;
        RolePath rootRole = new RolePath();
        if (!rootRole.exists()) {
            Gateway.getLookupManager().createRole(rootRole);
        }
        if (!(adminRole = new RolePath(rootRole, "Admin", false)).exists()) {
            Gateway.getLookupManager().createRole(adminRole);
        }
        AgentProxy system = Bootstrap.checkAgent("system", null, adminRole, new UUID(0L, 1L).toString());
        ScriptConsole.setUser(system);
        String ucRole = Gateway.getProperties().getString("UserCode.roleOverride", "UserCode");
        RolePath usercodeRole = new RolePath(rootRole, ucRole, true);
        if (!usercodeRole.exists()) {
            Gateway.getLookupManager().createRole(usercodeRole);
        }
        Bootstrap.checkAgent(Gateway.getProperties().getString(ucRole + ".agent", InetAddress.getLocalHost().getHostName()), Gateway.getProperties().getString(ucRole + ".password", "uc"), usercodeRole, UUID.randomUUID().toString());
    }

    public static void createServerItem() throws Exception {
        ItemPath serverItem;
        LookupManager lookupManager = Gateway.getLookupManager();
        String serverName = Gateway.getProperties().getString("ItemServer.name", InetAddress.getLocalHost().getHostName());
        thisServerPath = new DomainPath("/servers/" + serverName);
        try {
            serverItem = thisServerPath.getItemPath();
        }
        catch (ObjectNotFoundException ex) {
            Logger.msg("Creating server item " + thisServerPath, new Object[0]);
            serverItem = new ItemPath();
            Gateway.getCorbaServer().createItem(serverItem);
            lookupManager.add(serverItem);
            thisServerPath.setItemPath(serverItem);
            lookupManager.add(thisServerPath);
        }
        int proxyPort = Gateway.getProperties().getInt("ItemServer.Proxy.port", 1553);
        Gateway.getStorage().put(serverItem, new Property(BuiltInItemProperties.NAME, serverName, false), null);
        Gateway.getStorage().put(serverItem, new Property(BuiltInItemProperties.TYPE, "Server", false), null);
        Gateway.getStorage().put(serverItem, new Property(BuiltInItemProperties.KERNEL_VERSION, Gateway.getKernelVersion(), true), null);
        Gateway.getStorage().put(serverItem, new Property("ProxyPort", String.valueOf(proxyPort), false), null);
        Gateway.getStorage().put(serverItem, new Property("ConsolePort", String.valueOf(Logger.getConsolePort()), true), null);
        Gateway.getProxyManager().connectToProxyServer(serverName, proxyPort);
    }

    public static void initServerItemWf() throws Exception {
        CompositeActivityDef serverWfCa = (CompositeActivityDef)LocalObjectLoader.getActDef("ServerItemWorkflow", 0);
        Workflow wf = new Workflow((CompositeActivity)serverWfCa.instantiate(), new ServerPredefinedStepContainer());
        wf.initialise(thisServerPath.getItemPath(), systemAgents.get("system").getPath(), null);
        Gateway.getStorage().put(thisServerPath.getItemPath(), wf, null);
    }

    static {
        systemAgents = new HashMap();
        shutdown = false;
    }
}

