/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.agent;

import java.util.List;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.common.SystemKey;
import org.cristalise.kernel.entity.AgentOperations;
import org.cristalise.kernel.entity.ItemImplementation;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.agent.JobArrayList;
import org.cristalise.kernel.entity.agent.JobList;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStepContainer;
import org.cristalise.kernel.lifecycle.instance.predefined.agent.AgentPredefinedStepContainer;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;

public class AgentImplementation
extends ItemImplementation
implements AgentOperations {
    private JobList currentJobs;

    public AgentImplementation(AgentPath path) {
        super(path);
        try {
            this.currentJobs = (JobList)this.mStorage.get(path, ClusterType.JOB.getName(), path);
        }
        catch (ObjectNotFoundException | PersistencyException ex) {
            Logger.error((Throwable)ex);
        }
    }

    @Override
    public synchronized void refreshJobList(SystemKey sysKey, String stepPath, String newJobs) {
        try {
            ItemPath itemPath = new ItemPath(sysKey);
            JobArrayList newJobList = (JobArrayList)Gateway.getMarshaller().unmarshall(newJobs);
            List<String> keysToRemove = this.currentJobs.getKeysForStep(itemPath, stepPath);
            for (Job newJob : newJobList.list) {
                Logger.msg(6, "AgentImplementation.refreshJobList() - Adding job:" + newJob.getItemPath() + "/" + newJob.getStepPath() + ":" + newJob.getTransition().getName(), new Object[0]);
                this.currentJobs.addJob(newJob);
            }
            for (String key : keysToRemove) {
                this.currentJobs.remove(key);
            }
            Gateway.getStorage().commit(this.mItemPath);
        }
        catch (Throwable ex) {
            Logger.error("Could not refresh job list.", new Object[0]);
            Logger.error(ex);
            Gateway.getStorage().abort(this.mItemPath);
        }
    }

    @Override
    public void addRole(String roleName) throws CannotManageException, ObjectNotFoundException {
        RolePath newRole = Gateway.getLookup().getRolePath(roleName);
        try {
            Gateway.getLookupManager().addRole((AgentPath)this.mItemPath, newRole);
        }
        catch (ObjectCannotBeUpdated ex) {
            throw new CannotManageException("Could not update role");
        }
    }

    @Override
    public void removeRole(String roleName) throws CannotManageException, ObjectNotFoundException {
        RolePath rolePath = Gateway.getLookup().getRolePath(roleName);
        try {
            Gateway.getLookupManager().removeRole((AgentPath)this.mItemPath, rolePath);
        }
        catch (ObjectCannotBeUpdated ex) {
            throw new CannotManageException("Could not update role");
        }
    }

    @Override
    protected PredefinedStepContainer getNewPredefStepContainer() {
        return new AgentPredefinedStepContainer();
    }

    @Override
    protected void finalize() throws Throwable {
        Logger.msg(7, "AgentImplementation.finalize() - Reaping " + this.mItemPath, new Object[0]);
        if (this.currentJobs != null) {
            this.currentJobs.deactivate();
        }
        Gateway.getStorage().clearCache(this.mItemPath, null);
        super.finalize();
    }
}

