/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.proxy;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.DomainPathSubscriber;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.entity.proxy.ProxyMessage;
import org.cristalise.kernel.entity.proxy.ProxyMessageListener;
import org.cristalise.kernel.entity.proxy.ProxyServerConnection;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.kernel.utils.SoftCache;
import org.omg.CORBA.Object;

public class ProxyManager {
    public static final String CONFIG_STRICT_POLICY = "ProxyManager.strictPolicy";
    SoftCache<ItemPath, ItemProxy> proxyPool = new SoftCache(50);
    HashMap<DomainPathSubscriber, DomainPath> treeSubscribers = new HashMap();
    HashMap<String, ProxyServerConnection> connections = new HashMap();
    ProxyMessageListener messageListener = null;

    public ProxyManager() throws InvalidDataException {
        Logger.msg(5, "ProxyManager() - Starting.....", new java.lang.Object[0]);
        Iterator<Path> servers = Gateway.getLookup().search((Path)new DomainPath("/servers"), new Property(BuiltInItemProperties.TYPE, "Server", false));
        while (servers.hasNext()) {
            Path thisServerResult = servers.next();
            try {
                ItemPath thisServerPath = thisServerResult.getItemPath();
                String remoteServer = ((Property)Gateway.getStorage().get(thisServerPath, (java.lang.Object)((java.lang.Object)ClusterType.PROPERTY) + "/" + (java.lang.Object)((java.lang.Object)BuiltInItemProperties.NAME), null)).getValue();
                String portStr = ((Property)Gateway.getStorage().get(thisServerPath, (java.lang.Object)((java.lang.Object)ClusterType.PROPERTY) + "/ProxyPort", null)).getValue();
                this.connectToProxyServer(remoteServer, Integer.parseInt(portStr));
            }
            catch (Exception ex) {
                Logger.error("Exception retrieving proxy server connection data for " + thisServerResult, new java.lang.Object[0]);
                Logger.error(ex);
            }
        }
        try {
            if (Gateway.getProperties().containsKey("ProxyMessageListener")) {
                this.messageListener = (ProxyMessageListener)Gateway.getProperties().getInstance("ProxyMessageListener");
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            Logger.error(e);
            throw new InvalidDataException(e.getMessage());
        }
    }

    public void connectToProxyServer(String name, int port) {
        ProxyServerConnection oldConn = this.connections.get(name);
        if (oldConn != null) {
            oldConn.shutdown();
        }
        this.connections.put(name, new ProxyServerConnection(name, port, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resubscribe(ProxyServerConnection conn) {
        SoftCache<ItemPath, ItemProxy> softCache = this.proxyPool;
        synchronized (softCache) {
            for (ItemPath key : this.proxyPool.keySet()) {
                ProxyMessage sub = new ProxyMessage(key, "add", false);
                Logger.msg(5, "ProxyManager.resubscribe() - item:" + key, new java.lang.Object[0]);
                conn.sendMessage(sub);
            }
        }
    }

    private void sendMessage(ProxyMessage sub) {
        for (ProxyServerConnection element : this.connections.values()) {
            element.sendMessage(sub);
        }
    }

    public void shutdown() {
        Logger.msg("ProxyManager.shutdown() - flagging shutdown of server connections", new java.lang.Object[0]);
        for (ProxyServerConnection element : this.connections.values()) {
            element.shutdown();
        }
    }

    protected void processMessage(ProxyMessage thisMessage) throws InvalidDataException {
        if (Logger.doLog(9)) {
            Logger.msg(9, thisMessage.toString(), new java.lang.Object[0]);
        }
        if (thisMessage.getPath().equals("ping")) {
            return;
        }
        if (thisMessage.getItemPath() == null) {
            this.informTreeSubscribers(thisMessage.isState(), thisMessage.getPath());
        } else {
            Logger.msg(5, "ProxyManager.processMessage() - Received proxy message: " + thisMessage.toString(), new java.lang.Object[0]);
            ItemProxy relevant = this.proxyPool.get(thisMessage.getItemPath());
            if (relevant == null) {
                Logger.warning("Received proxy message for sysKey " + thisMessage.getItemPath() + " which we don't have a proxy for.", new java.lang.Object[0]);
            } else {
                try {
                    relevant.notify(thisMessage);
                }
                catch (Throwable ex) {
                    Logger.error("Error caught notifying proxy listener " + relevant.toString() + " of " + thisMessage.toString(), new java.lang.Object[0]);
                    Logger.error(ex);
                }
            }
        }
        if (this.messageListener != null) {
            this.messageListener.notifyMessage(thisMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informTreeSubscribers(boolean state, String path) {
        DomainPath last = new DomainPath(path);
        boolean first = true;
        HashMap<DomainPathSubscriber, DomainPath> hashMap = this.treeSubscribers;
        synchronized (hashMap) {
            DomainPath parent;
            while ((parent = last.getParent()) != null) {
                ArrayList<DomainPathSubscriber> currentKeys = new ArrayList<DomainPathSubscriber>();
                currentKeys.addAll(this.treeSubscribers.keySet());
                for (DomainPathSubscriber sub : currentKeys) {
                    DomainPath interest = this.treeSubscribers.get(sub);
                    if (interest == null || !interest.equals(parent)) continue;
                    if (!state) {
                        sub.pathAdded(last);
                        continue;
                    }
                    if (!first) continue;
                    sub.pathRemoved(last);
                }
                last = parent;
                first = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeTree(DomainPathSubscriber sub, DomainPath interest) {
        HashMap<DomainPathSubscriber, DomainPath> hashMap = this.treeSubscribers;
        synchronized (hashMap) {
            this.treeSubscribers.put(sub, interest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeTree(DomainPathSubscriber sub) {
        HashMap<DomainPathSubscriber, DomainPath> hashMap = this.treeSubscribers;
        synchronized (hashMap) {
            this.treeSubscribers.remove(sub);
        }
    }

    private ItemProxy createProxy(Object ior, ItemPath itemPath) throws ObjectNotFoundException {
        ItemProxy newProxy = null;
        Logger.msg(5, "ProxyManager.createProxy() - Item:" + itemPath, new java.lang.Object[0]);
        newProxy = itemPath instanceof AgentPath ? new AgentProxy(ior, (AgentPath)itemPath) : new ItemProxy(ior, itemPath);
        ProxyMessage sub = new ProxyMessage(itemPath, "add", false);
        this.sendMessage(sub);
        this.reportCurrentProxies(9);
        return newProxy;
    }

    protected void removeProxy(ItemPath itemPath) {
        ProxyMessage sub = new ProxyMessage(itemPath, "del", true);
        Logger.msg(5, "ProxyManager.removeProxy() - Unsubscribing to proxy informer for " + itemPath, new java.lang.Object[0]);
        this.sendMessage(sub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ItemProxy getProxy(Object ior, ItemPath itemPath) throws ObjectNotFoundException {
        SoftCache<ItemPath, ItemProxy> softCache = this.proxyPool;
        synchronized (softCache) {
            ItemProxy newProxy = this.proxyPool.get(itemPath);
            if (newProxy == null) {
                newProxy = this.createProxy(ior, itemPath);
                this.proxyPool.put(itemPath, newProxy);
            }
            return newProxy;
        }
    }

    public ItemProxy getProxy(Path path) throws ObjectNotFoundException {
        ItemPath itemPath = path instanceof ItemPath ? (ItemPath)path : path.getItemPath();
        Logger.msg(8, "ProxyManager::getProxy(" + path.toString() + ")", new java.lang.Object[0]);
        return this.getProxy(itemPath.getIOR(), itemPath);
    }

    public AgentProxy getAgentProxy(AgentPath path) throws ObjectNotFoundException {
        return (AgentProxy)this.getProxy(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportCurrentProxies(int logLevel) {
        if (!Logger.doLog(logLevel)) {
            return;
        }
        Logger.msg(logLevel, "Current proxies: ", new java.lang.Object[0]);
        try {
            SoftCache<ItemPath, ItemProxy> softCache = this.proxyPool;
            synchronized (softCache) {
                Iterator<ItemPath> i = this.proxyPool.keySet().iterator();
                int count = 0;
                while (i.hasNext()) {
                    ItemPath nextProxy = i.next();
                    ItemProxy thisProxy = this.proxyPool.get(nextProxy);
                    if (thisProxy != null) {
                        Logger.msg(logLevel, "" + count + ": " + this.proxyPool.get(nextProxy).getClass().getName() + ": " + nextProxy, new java.lang.Object[0]);
                    }
                    ++count;
                }
            }
        }
        catch (ConcurrentModificationException ex) {
            Logger.msg(logLevel, "Proxy cache modified. Aborting.", new java.lang.Object[0]);
        }
    }
}

