/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.transfer;

import java.io.File;
import java.util.ArrayList;
import org.cristalise.kernel.entity.transfer.TransferItem;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.Logger;

public class TransferSet {
    public ArrayList<TransferItem> items;

    public TransferSet() {
    }

    public TransferSet(ItemPath[] itemPaths) {
        this.items = new ArrayList();
        for (ItemPath item : itemPaths) {
            try {
                this.items.add(new TransferItem(item));
            }
            catch (Exception ex) {
                Logger.error("Could not add item " + item, new Object[0]);
                Logger.error(ex);
            }
        }
    }

    public void exportPackage(File dir) throws Exception {
        if (this.items == null || this.items.size() == 0) {
            throw new Exception("Nothing to dump");
        }
        FileStringUtility.createNewDir(dir.getAbsolutePath());
        for (TransferItem element : this.items) {
            try {
                element.exportItem(new File(dir, element.itemPath.getUUID().toString()), "/");
            }
            catch (Exception ex) {
                Logger.error("Error dumping item " + element.itemPath, new Object[0]);
                Logger.error(ex);
            }
        }
        try {
            String self = Gateway.getMarshaller().marshall(this);
            FileStringUtility.string2File(new File(dir, "transferSet.xml"), self);
        }
        catch (Exception ex) {
            Logger.error("Error writing header file", new Object[0]);
            Logger.error(ex);
        }
    }

    public void importPackage(File rootDir) {
        for (TransferItem element : this.items) {
            Logger.msg(5, "Importing " + element.itemPath, new Object[0]);
            try {
                element.importItem(new File(rootDir, element.itemPath.getUUID().toString()));
            }
            catch (Exception ex) {
                Logger.error("Import of item " + element.itemPath + " failed. Rolling back", new Object[0]);
                Logger.error(ex);
                Gateway.getStorage().abort(element);
            }
        }
    }
}

