/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.graph.model;

import java.util.Hashtable;
import org.cristalise.kernel.graph.event.ClearedEvent;
import org.cristalise.kernel.graph.event.EdgeRemovedEvent;
import org.cristalise.kernel.graph.event.EdgesChangedEvent;
import org.cristalise.kernel.graph.event.ForcedNotifyEvent;
import org.cristalise.kernel.graph.event.GraphModelEvent;
import org.cristalise.kernel.graph.event.GraphModelResizedEvent;
import org.cristalise.kernel.graph.event.NewEdgeEndPointChangedEvent;
import org.cristalise.kernel.graph.event.StartVertexIdChangedEvent;
import org.cristalise.kernel.graph.event.VertexAddedEvent;
import org.cristalise.kernel.graph.event.VertexCreatedEvent;
import org.cristalise.kernel.graph.event.VertexMovedEvent;
import org.cristalise.kernel.graph.event.VertexRemovedEvent;
import org.cristalise.kernel.graph.event.VerticesChangedEvent;
import org.cristalise.kernel.graph.model.DirectedEdge;
import org.cristalise.kernel.graph.model.EdgeFactory;
import org.cristalise.kernel.graph.model.GraphModelCastorData;
import org.cristalise.kernel.graph.model.GraphModelManager;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.graph.model.TypeNameAndConstructionInfo;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.graph.model.VertexFactory;
import org.cristalise.kernel.graph.model.VertexOutlineCreator;
import org.cristalise.kernel.utils.Logger;

public class GraphModel {
    private int mWidth = 0;
    private int mHeight = 0;
    private int mNextId = 0;
    protected int mStartVertexId = -1;
    protected Hashtable<String, Vertex> mVertexHashtable = new Hashtable();
    protected Hashtable<String, DirectedEdge> mEdgeHashtable = new Hashtable();
    private GraphableVertex mContainingVertex;
    protected transient Vertex mNewEdgeOriginVertex = null;
    protected transient GraphPoint mNewEdgeEndPoint = null;
    private transient GraphModelManager mManager = null;
    private VertexFactory mExternalVertexFactory = null;
    private EdgeFactory mExternalEdgeFactory = null;
    private VertexOutlineCreator mVertexOutlineCreator = null;
    private final ClearedEvent mClearedEvent = new ClearedEvent();
    private final EdgeRemovedEvent mEdgeRemovedEvent = new EdgeRemovedEvent();
    private final EdgesChangedEvent mEdgesChangedEvent = new EdgesChangedEvent();
    private final ForcedNotifyEvent mForcedNotifyEvent = new ForcedNotifyEvent();
    private final NewEdgeEndPointChangedEvent mNewEdgeEndPointChangedEvent = new NewEdgeEndPointChangedEvent();
    private final StartVertexIdChangedEvent mStartVertexIdChangedEvent = new StartVertexIdChangedEvent();
    private final VertexAddedEvent mVertexAddedEvent = new VertexAddedEvent();
    private final VertexCreatedEvent mVertexCreatedEvent = new VertexCreatedEvent();
    private final VertexMovedEvent mVertexMovedEvent = new VertexMovedEvent();
    private final VertexRemovedEvent mVertexRemovedEvent = new VertexRemovedEvent();
    private final VerticesChangedEvent mVerticesChangedEvent = new VerticesChangedEvent();
    private final GraphModelResizedEvent mGraphModelResizedEvent = new GraphModelResizedEvent();
    private static int count = 0;
    private int number;

    public GraphModel() {
        this.number = ++count;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNextId(int id) {
        this.mNextId = id;
    }

    public int getNextId() {
        return this.mNextId;
    }

    public void setManager(GraphModelManager mgr) {
        this.mManager = mgr;
    }

    public GraphModelManager getManager() {
        return this.mManager;
    }

    public GraphModel(VertexOutlineCreator vertexOutlineCreator) {
        this.mVertexOutlineCreator = vertexOutlineCreator;
    }

    public void setWidth(int width) {
        this.mWidth = width;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public void setHeight(int height) {
        this.mHeight = height;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public void checkSize(Vertex v) {
        boolean resized = false;
        GraphPoint centre = v.getCentrePoint();
        if (this.getWidth() < centre.x + v.getWidth() / 2 + 10) {
            this.setWidth(centre.x + v.getWidth() / 2 + 10);
            resized = true;
        }
        if (this.getHeight() < centre.y + v.getHeight() / 2 + 10) {
            this.setHeight(centre.y + v.getHeight() / 2 + 10);
            resized = true;
        }
        if (resized) {
            this.publishEvent(this.mGraphModelResizedEvent);
        }
    }

    public void setStartVertexId(int id) {
        this.mStartVertexId = id;
        this.publishEvent(this.mStartVertexIdChangedEvent);
    }

    public int getStartVertexId() {
        return this.mStartVertexId;
    }

    public Vertex getStartVertex() {
        return this.resolveVertex(this.getStartVertexId());
    }

    public GraphableVertex getContainingVertex() {
        return this.mContainingVertex;
    }

    public void setContainingVertex(GraphableVertex vertex) {
        this.mContainingVertex = vertex;
    }

    public void setVertices(Vertex[] vertices) {
        this.mVertexHashtable = new Hashtable();
        for (Vertex vertice : vertices) {
            this.mVertexHashtable.put(String.valueOf(vertice.getID()), vertice);
            this.checkSize(vertice);
        }
        this.publishEvent(this.mVerticesChangedEvent);
    }

    public Vertex[] getVertices() {
        Object[] vertexObjs = this.mVertexHashtable.values().toArray();
        Vertex[] vertices = new Vertex[vertexObjs.length];
        int i = 0;
        for (i = 0; i < vertices.length; ++i) {
            vertices[i] = (Vertex)vertexObjs[i];
        }
        return vertices;
    }

    public void setEdges(DirectedEdge[] edges) {
        this.mEdgeHashtable = new Hashtable();
        for (DirectedEdge edge : edges) {
            this.mEdgeHashtable.put(String.valueOf(edge.getID()), edge);
        }
        this.publishEvent(this.mEdgesChangedEvent);
    }

    public DirectedEdge[] getEdges() {
        Object[] edgeObjs = this.mEdgeHashtable.values().toArray();
        DirectedEdge[] edges = new DirectedEdge[edgeObjs.length];
        int i = 0;
        for (i = 0; i < edges.length; ++i) {
            edges[i] = (DirectedEdge)edgeObjs[i];
        }
        return edges;
    }

    public Vertex getVertexById(int id) {
        return this.mVertexHashtable.get(String.valueOf(id));
    }

    public int addEdgeAndCreateId(DirectedEdge e, int originId, int terminusId) {
        return this.addEdgeAndCreateId(e, this.resolveVertex(originId), this.resolveVertex(terminusId));
    }

    public int addEdgeAndCreateId(DirectedEdge e, Vertex origin, Vertex terminus) {
        e.setID(this.mNextId);
        e.setOriginVertexId(origin.getID());
        e.setOriginPoint(origin.getCentrePoint());
        e.setTerminusVertexId(terminus.getID());
        e.setTerminusPoint(terminus.getCentrePoint());
        origin.addOutEdgeId(this.mNextId);
        terminus.addInEdgeId(this.mNextId);
        this.mEdgeHashtable.put(String.valueOf(this.mNextId), e);
        ++this.mNextId;
        return this.mNextId - 1;
    }

    public void removeEdge(DirectedEdge e) {
        Vertex origin = this.getOrigin(e);
        Vertex terminus = this.getTerminus(e);
        int edgeId = e.getID();
        origin.removeOutEdgeId(edgeId);
        terminus.removeInEdgeId(edgeId);
        this.mEdgeHashtable.remove(String.valueOf(e.getID()));
        this.publishEvent(this.mEdgeRemovedEvent);
    }

    public int addVertexAndCreateId(Vertex v, GraphPoint location) {
        if (location != null) {
            if (this.mVertexOutlineCreator == null) {
                Logger.warning("You cannot add a vertex with no outline creator", new Object[0]);
                return -1;
            }
            this.placeVertex(v, location);
        }
        this.mVertexHashtable.put(String.valueOf(this.mNextId), v);
        v.setID(this.mNextId);
        return this.mNextId++;
    }

    public void placeVertex(Vertex v, GraphPoint location) {
        v.setCentrePoint(location);
        if (this.mVertexOutlineCreator != null) {
            this.mVertexOutlineCreator.setOutline(v);
        }
        this.publishEvent(this.mVertexAddedEvent);
        this.checkSize(v);
    }

    public void removeVertex(Vertex v) {
        DirectedEdge[] inEdges = this.getInEdges(v);
        DirectedEdge[] outEdges = this.getOutEdges(v);
        Vertex origin = null;
        Vertex terminus = null;
        int edgeId = -1;
        int i = 0;
        for (i = 0; i < inEdges.length; ++i) {
            edgeId = inEdges[i].getID();
            origin = this.getOrigin(inEdges[i]);
            origin.removeOutEdgeId(edgeId);
            this.mEdgeHashtable.remove(String.valueOf(edgeId));
        }
        for (i = 0; i < outEdges.length; ++i) {
            edgeId = outEdges[i].getID();
            terminus = this.getTerminus(outEdges[i]);
            terminus.removeInEdgeId(edgeId);
            this.mEdgeHashtable.remove(String.valueOf(edgeId));
        }
        this.mVertexHashtable.remove(String.valueOf(v.getID()));
        this.publishEvent(this.mVertexRemovedEvent);
    }

    public void moveAbsoluteVertex(Vertex v, GraphPoint p) {
        if (p.x < 0) {
            p.x = 0;
        }
        if (p.y < 0) {
            p.y = 0;
        }
        if (p.x > this.mWidth) {
            p.x = this.mWidth;
        }
        if (p.y > this.mHeight) {
            p.y = this.mHeight;
        }
        this.moveAbsoluteVertexAndConnectingEdges(v, p);
        this.publishEvent(this.mVertexMovedEvent);
    }

    private void moveAbsoluteVertexAndConnectingEdges(Vertex v, GraphPoint p) {
        DirectedEdge[] inEdges = this.getInEdges(v);
        DirectedEdge[] outEdges = this.getOutEdges(v);
        int i = 0;
        v.moveAbsolute(p);
        for (i = 0; i < inEdges.length; ++i) {
            inEdges[i].setTerminusPoint(p);
        }
        for (i = 0; i < outEdges.length; ++i) {
            outEdges[i].setOriginPoint(p);
        }
        this.checkSize(v);
    }

    public Vertex resolveVertex(int id) {
        return this.mVertexHashtable.get(String.valueOf(id));
    }

    public DirectedEdge resolveEdge(int id) {
        return this.mEdgeHashtable.get(String.valueOf(id));
    }

    public DirectedEdge[] getInEdges(Vertex v) {
        int[] ids = v.getInEdgeIds();
        return this.resolveEdges(ids);
    }

    public DirectedEdge[] getOutEdges(Vertex v) {
        int[] ids = v.getOutEdgeIds();
        return this.resolveEdges(ids);
    }

    private DirectedEdge[] resolveEdges(int[] ids) {
        DirectedEdge[] edges = new DirectedEdge[ids.length];
        int i = 0;
        for (i = 0; i < ids.length; ++i) {
            edges[i] = this.resolveEdge(ids[i]);
        }
        return edges;
    }

    public Vertex getOrigin(DirectedEdge e) {
        return this.resolveVertex(e.getOriginVertexId());
    }

    public Vertex getTerminus(DirectedEdge e) {
        return this.resolveVertex(e.getTerminusVertexId());
    }

    public Vertex[] getInVertices(Vertex v) {
        DirectedEdge[] inEdges = this.getInEdges(v);
        Vertex[] inVertices = new Vertex[inEdges.length];
        int i = 0;
        for (i = 0; i < inEdges.length; ++i) {
            inVertices[i] = this.getOrigin(inEdges[i]);
        }
        return inVertices;
    }

    public Vertex[] getOutVertices(Vertex v) {
        DirectedEdge[] outEdges = this.getOutEdges(v);
        Vertex[] outVertices = new Vertex[outEdges.length];
        int i = 0;
        for (i = 0; i < outEdges.length; ++i) {
            outVertices[i] = this.getTerminus(outEdges[i]);
        }
        return outVertices;
    }

    public DirectedEdge[] getConnectingEdges(int originVertexId, int terminusVertexId) {
        Vertex origin = this.resolveVertex(originVertexId);
        DirectedEdge[] outEdges = null;
        int numEdgesFound = 0;
        DirectedEdge[] edgesFound = null;
        int i = 0;
        int j = 0;
        if (origin == null) {
            return null;
        }
        outEdges = this.getOutEdges(origin);
        for (i = 0; i < outEdges.length; ++i) {
            if (outEdges[i].getTerminusVertexId() != terminusVertexId) continue;
            ++numEdgesFound;
        }
        edgesFound = new DirectedEdge[numEdgesFound];
        for (i = 0; i < outEdges.length; ++i) {
            if (outEdges[i].getTerminusVertexId() != terminusVertexId) continue;
            edgesFound[j] = outEdges[i];
            ++j;
        }
        return edgesFound;
    }

    public void clearTags(Object tag) {
        Vertex vertex = null;
        Object[] vertexObjs = this.mVertexHashtable.values().toArray();
        int i = 0;
        for (i = 0; i < vertexObjs.length; ++i) {
            vertex = (Vertex)vertexObjs[i];
            vertex.clearTag(tag);
        }
    }

    public void forceNotify() {
        this.publishEvent(this.mForcedNotifyEvent);
    }

    public void clear() {
        this.mVertexHashtable = new Hashtable();
        this.mEdgeHashtable = new Hashtable();
        this.mStartVertexId = -1;
        this.publishEvent(this.mClearedEvent);
    }

    public void setNewEdgeOriginVertex(Vertex v) {
        this.mNewEdgeOriginVertex = v;
    }

    public Vertex getNewEdgeOriginVertex() {
        return this.mNewEdgeOriginVertex;
    }

    public void setNewEdgeEndPoint(GraphPoint p) {
        this.mNewEdgeEndPoint = p;
        this.publishEvent(this.mNewEdgeEndPointChangedEvent);
    }

    public GraphPoint getNewEdgeEndPoint() {
        return this.mNewEdgeEndPoint;
    }

    public void setExternalVertexFactory(VertexFactory factory) {
        this.mExternalVertexFactory = factory;
    }

    public void createVertex(GraphPoint location, TypeNameAndConstructionInfo typeNameAndConstructionInfo) throws Exception {
        if (this.mExternalVertexFactory != null) {
            this.mExternalVertexFactory.create(this.mManager, location, typeNameAndConstructionInfo);
            this.publishEvent(this.mVertexCreatedEvent);
        }
    }

    private void publishEvent(GraphModelEvent event) {
        if (this.mManager != null) {
            this.mManager.notifyObservers(event);
        }
    }

    public void setExternalEdgeFactory(EdgeFactory factory) {
        this.mExternalEdgeFactory = factory;
    }

    public void setVertexOutlineCreator(VertexOutlineCreator outlineCreator) {
        this.mVertexOutlineCreator = outlineCreator;
    }

    public void createDirectedEdge(Vertex origin, Vertex terminus, TypeNameAndConstructionInfo typeNameAndConstructionInfo) {
        if (this.mExternalEdgeFactory != null) {
            this.mExternalEdgeFactory.create(this.mManager, origin, terminus, typeNameAndConstructionInfo);
        }
    }

    public void resetVertexOutlines() {
        Vertex[] vertices = this.getVertices();
        int i = 0;
        for (i = 0; i < vertices.length; ++i) {
            this.mVertexOutlineCreator.setOutline(vertices[i]);
        }
    }

    public void setGraphModelCastorData(GraphModelCastorData data) {
        int i = 0;
        this.mVertexHashtable = new Hashtable();
        for (i = 0; i < data.mVertexImpls.length; ++i) {
            this.mVertexHashtable.put(String.valueOf(data.mVertexImpls[i].getID()), data.mVertexImpls[i]);
            this.checkSize(data.mVertexImpls[i]);
        }
        this.mEdgeHashtable = new Hashtable();
        for (i = 0; i < data.mEdgeImpls.length; ++i) {
            this.mEdgeHashtable.put(String.valueOf(data.mEdgeImpls[i].getID()), data.mEdgeImpls[i]);
        }
        this.mStartVertexId = data.mStartVertexId;
        this.mNextId = data.mNextId;
    }

    public GraphModelCastorData getGraphModelCastorData() {
        Object[] vertexObjs = this.mVertexHashtable.values().toArray();
        Vertex[] vertexImpls = new Vertex[vertexObjs.length];
        Object[] edgeObjs = this.mEdgeHashtable.values().toArray();
        DirectedEdge[] directedEdgeImpls = new DirectedEdge[edgeObjs.length];
        String className = null;
        int i = 0;
        for (i = 0; i < vertexImpls.length; ++i) {
            vertexImpls[i] = (Vertex)vertexObjs[i];
        }
        for (i = 0; i < directedEdgeImpls.length; ++i) {
            directedEdgeImpls[i] = (DirectedEdge)edgeObjs[i];
        }
        return new GraphModelCastorData(className, vertexImpls, directedEdgeImpls, this.mStartVertexId, this.mNextId);
    }
}

