/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle;

import org.cristalise.kernel.collection.BuiltInCollections;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.graph.traversal.GraphTraversal;
import org.cristalise.kernel.lifecycle.ActivityDef;
import org.cristalise.kernel.lifecycle.CompositeActivityDef;
import org.cristalise.kernel.lifecycle.WfVertexDef;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lifecycle.instance.WfVertex;
import org.cristalise.kernel.utils.DescriptionObject;
import org.cristalise.kernel.utils.KeyValuePair;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;

public class ActivitySlotDef
extends WfVertexDef {
    private String activityDef;
    private ActivityDef theActivityDef;

    public ActivitySlotDef() {
    }

    public ActivitySlotDef(String name, ActivityDef actDef) {
        this.setName(name);
        this.setBuiltInProperty(BuiltInVertexProperties.NAME, name);
        this.setTheActivityDef(actDef);
    }

    public void setActivityDef(String oActivityDef) {
        this.activityDef = oActivityDef;
        this.theActivityDef = null;
    }

    public String getActivityDef() {
        return this.activityDef;
    }

    public ActivityDef getTheActivityDef() throws ObjectNotFoundException, InvalidDataException {
        if (this.theActivityDef == null) {
            try {
                DescriptionObject[] parentActDefs;
                Logger.msg(5, "ActivitySlotDef.getTheActivityDef() - try to load from item desc collection of ActSlotDef:" + this.getName(), new Object[0]);
                for (DescriptionObject thisActDef : parentActDefs = ((CompositeActivityDef)this.getParent()).getBuiltInCollectionResource(BuiltInCollections.ACTIVITY)) {
                    String childUUID = thisActDef.getItemID();
                    Logger.msg(5, "ActivitySlotDef.getTheActivityDef() - Collection childUUID:" + childUUID + " of ActSlotDef:" + this.getName(), new Object[0]);
                    if (!childUUID.equals(this.getActivityDef()) && !thisActDef.getName().equals(this.getActivityDef())) continue;
                    ActivityDef currentActDef = (ActivityDef)thisActDef;
                    Integer requiredVersion = this.deriveVersionNumber(this.getBuiltInProperty(BuiltInVertexProperties.VERSION));
                    if (currentActDef.getVersion() != requiredVersion) {
                        this.setTheActivityDef(LocalObjectLoader.getActDef(childUUID, requiredVersion));
                    } else {
                        this.setTheActivityDef(currentActDef);
                    }
                    break;
                }
            }
            catch (ObjectNotFoundException parentActDefs) {
                // empty catch block
            }
            if (this.theActivityDef == null) {
                Logger.msg(5, "ActivitySlotDef.getTheActivityDef() - try to load from property of ActSlotDef:" + this.getName(), new Object[0]);
                Integer version = this.deriveVersionNumber(this.getBuiltInProperty(BuiltInVertexProperties.VERSION));
                if (version == null) {
                    throw new InvalidDataException("No version defined in ActivityDefSlot " + this.getName());
                }
                this.setTheActivityDef(LocalObjectLoader.getActDef(this.getActivityDef(), version));
            }
        }
        return this.theActivityDef;
    }

    public void setTheActivityDef(ActivityDef actDef) {
        this.theActivityDef = actDef;
        this.activityDef = actDef.getItemID();
        this.setBuiltInProperty(BuiltInVertexProperties.VERSION, actDef.getVersion());
        if (actDef instanceof CompositeActivityDef) {
            this.mIsComposite = true;
        }
        Logger.msg(5, "ActivitySlotDef.setTheActivityDef() - ActSlotDef:" + this.getName() + " UUID:" + this.activityDef, new Object[0]);
    }

    @Override
    public boolean verify() {
        this.mErrors.removeAllElements();
        boolean err = true;
        int nbInEdgres = this.getInEdges().length;
        int nbOutEdges = this.getOutEdges().length;
        if (nbInEdgres == 0 && this.getID() != this.getParent().getChildrenGraphModel().getStartVertexId()) {
            this.mErrors.add("Unreachable");
            err = false;
        }
        if (nbInEdgres > 1) {
            this.mErrors.add("Bad nb of previous");
            err = false;
        }
        if (nbOutEdges > 1) {
            this.mErrors.add("too many next");
            err = false;
        }
        if (nbOutEdges == 0 && !((CompositeActivityDef)this.getParent()).hasGoodNumberOfActivity()) {
            this.mErrors.add("too many endpoints");
            err = false;
        }
        Vertex[] allSiblings = this.getParent().getChildrenGraphModel().getVertices();
        String thisName = (String)this.getBuiltInProperty(BuiltInVertexProperties.NAME);
        if (thisName == null || thisName.length() == 0) {
            this.mErrors.add("Slot name is empty");
        } else {
            for (Vertex v : allSiblings) {
                ActivitySlotDef otherSlot;
                String otherName;
                if (!(v instanceof ActivitySlotDef) || v.getID() == this.getID() || (otherName = (String)(otherSlot = (ActivitySlotDef)v).getBuiltInProperty(BuiltInVertexProperties.NAME)) == null || !otherName.equals(thisName)) continue;
                this.mErrors.add("Duplicate slot name");
                err = false;
            }
        }
        try {
            KeyValuePair[] props;
            for (KeyValuePair prop : props = this.getTheActivityDef().getProperties().getKeyValuePairs()) {
                if (!prop.isAbstract() || this.getProperties().containsKey(prop.getKey())) continue;
                this.mErrors.add("Abstract property '" + prop.getKey() + "' not defined in slot");
                err = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Vertex[] outV = this.getOutGraphables();
        Vertex[] anteVertices = GraphTraversal.getTraversal(this.getParent().getChildrenGraphModel(), this, 1, false);
        boolean errInLoop = false;
        for (Vertex element : outV) {
            for (Vertex anteVertice : anteVertices) {
                if (this.loop() || element.getID() != anteVertice.getID()) continue;
                errInLoop = true;
            }
        }
        if (errInLoop) {
            this.mErrors.add("Problem in Loop");
            err = false;
        }
        return err;
    }

    public WfVertexDef[] getNextWfVertices() {
        return (WfVertexDef[])this.getOutGraphables();
    }

    public boolean isLayoutable() {
        return true;
    }

    private void configureInstance(Activity act) {
        KeyValuePair[] k;
        for (KeyValuePair element : k = this.getProperties().getKeyValuePairs()) {
            act.getProperties().put(element.getKey(), element.getValue(), element.isAbstract());
        }
        act.setCentrePoint(this.getCentrePoint());
        act.setOutlinePoints(this.getOutlinePoints());
        act.setInEdgeIds(this.getInEdgeIds());
        act.setOutEdgeIds(this.getOutEdgeIds());
        act.setName(this.getActName());
        act.setID(this.getID());
    }

    public String getActName() {
        return (String)this.getBuiltInProperty(BuiltInVertexProperties.NAME);
    }

    @Override
    public WfVertex instantiate() throws ObjectNotFoundException, InvalidDataException {
        Activity newActivity = (Activity)this.getTheActivityDef().instantiate();
        this.configureInstance(newActivity);
        if (newActivity.getProperties().getAbstract().size() > 0) {
            throw new InvalidDataException("Abstract properties not overridden: " + newActivity.getProperties().getAbstract().toString());
        }
        return newActivity;
    }
}

