/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.stateMachine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lifecycle.instance.stateMachine.State;
import org.cristalise.kernel.lifecycle.instance.stateMachine.TransitionOutcome;
import org.cristalise.kernel.lifecycle.instance.stateMachine.TransitionQuery;
import org.cristalise.kernel.lifecycle.instance.stateMachine.TransitionScript;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.querying.Query;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;

public class Transition {
    int id;
    String name;
    int originStateId = -1;
    int targetStateId = -1;
    State originState;
    State targetState;
    String reservation;
    boolean errorHandler = false;
    String enabledProp;
    boolean requiresActive = true;
    boolean finishing;
    boolean reinitializes = false;
    String roleOverride;
    TransitionOutcome outcome;
    TransitionScript script;
    TransitionQuery query;

    public Transition() {
    }

    public Transition(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public Transition(int id, String name, int originStateId, int targetStateId) {
        this(id, name);
        this.originStateId = originStateId;
        this.targetStateId = targetStateId;
    }

    public void setTargetState(State targetState) {
        this.targetState = targetState;
        this.finishing = targetState.finished;
    }

    public boolean reinitializes() {
        return this.reinitializes;
    }

    public void setReinitializes(boolean reinit) {
        if (this.finishing) {
            throw new RuntimeException("Transition cannot be both reinitializing and finishing");
        }
        this.reinitializes = reinit;
    }

    public String getRoleOverride(CastorHashMap actProps) {
        return Transition.resolveValue(this.roleOverride, actProps);
    }

    protected boolean resolveStates(HashMap<Integer, State> states) {
        boolean allFound = true;
        if (states.keySet().contains(this.originStateId)) {
            this.setOriginState(states.get(this.originStateId));
            this.originState.addPossibleTransition(this);
        } else {
            allFound = false;
        }
        if (states.keySet().contains(this.targetStateId)) {
            this.setTargetState(states.get(this.targetStateId));
        } else {
            allFound = false;
        }
        return allFound;
    }

    public String getPerformingRole(Activity act, AgentPath agent) throws ObjectNotFoundException, AccessRightsException {
        if (!this.isEnabled(act)) {
            throw new AccessRightsException("Trans:" + this.toString() + " is disabled by the '" + this.enabledProp + "' property.");
        }
        if (this.isRequiresActive() && !act.getActive()) {
            throw new AccessRightsException("Activity must be active to perform trans:" + this.toString());
        }
        String overridingRole = this.getRoleOverride(act.getProperties());
        boolean override = overridingRole != null;
        boolean isOwner = false;
        boolean isOwned = true;
        String agentName = act.getCurrentAgentName();
        if (StringUtils.isNotBlank((CharSequence)agentName)) {
            if (agent.getAgentName().equals(agentName)) {
                isOwner = true;
            }
        } else {
            isOwned = false;
        }
        ArrayList<RolePath> roles = new ArrayList<RolePath>();
        if (override) {
            roles.add(Gateway.getLookup().getRolePath(overridingRole));
        } else {
            String actRole = act.getCurrentAgentRole();
            if (StringUtils.isNotBlank((CharSequence)actRole)) {
                for (String role : actRole.split(",")) {
                    roles.add(Gateway.getLookup().getRolePath(role.trim()));
                }
            }
        }
        if (isOwned && !override && !isOwner) {
            throw new AccessRightsException("Agent '" + agent.getAgentName() + "' cannot perform this trans:" + this.toString() + " because the activity '" + act.getName() + "' is currently owned by " + agentName);
        }
        if (roles.size() != 0) {
            RolePath matchingRole = agent.getFirstMatchingRole(roles);
            if (matchingRole != null) {
                return matchingRole.getName();
            }
            if (agent.hasRole("Admin")) {
                return "Admin";
            }
            throw new AccessRightsException("Agent '" + agent.getAgentName() + "' does not hold a suitable role '" + act.getCurrentAgentRole() + "' for the activity " + act.getName());
        }
        return null;
    }

    public String getReservation(Activity act, AgentPath agent) {
        if (StringUtils.isBlank((CharSequence)this.reservation)) {
            this.reservation = this.targetState.finished ? "clear" : "set";
        }
        String reservedAgent = act.getCurrentAgentName();
        if (this.reservation.equals("set")) {
            reservedAgent = agent.getAgentName();
        } else if (this.reservation.equals("clear")) {
            reservedAgent = "";
        }
        return reservedAgent;
    }

    private static String resolveValue(String key, CastorHashMap props) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        String result = key;
        Pattern propField = Pattern.compile("\\$\\{(.+?)\\}");
        Matcher propMatcher = propField.matcher(result);
        while (propMatcher.find()) {
            String propName = propMatcher.group(1);
            Object propValue = props.get(propName);
            String propValString = propValue == null ? "" : propValue.toString();
            result = result.replace("${" + propName + "}", propValString);
        }
        Logger.msg(8, "Transition.resolveValue() - returning key '" + key + "' as '" + result + "'", new Object[0]);
        return result;
    }

    public boolean isEnabled(Activity act) throws ObjectNotFoundException {
        if (StringUtils.isBlank((CharSequence)this.enabledProp)) {
            return true;
        }
        Logger.msg(5, "Transition.isEnabled() - trans:" + this.getName() + " enabledProp:" + this.enabledProp, new Object[0]);
        try {
            Object propValue = act.evaluateProperty(null, this.enabledProp, null);
            if (propValue == null) {
                return false;
            }
            return new Boolean(propValue.toString());
        }
        catch (InvalidDataException | PersistencyException e) {
            Logger.error((Throwable)e);
            throw new ObjectNotFoundException(e.getMessage());
        }
    }

    public boolean hasOutcome(CastorHashMap actProps) {
        if (this.outcome == null || actProps == null) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)Transition.resolveValue(this.outcome.schemaName, actProps))) {
            return false;
        }
        return !StringUtils.isEmpty((CharSequence)Transition.resolveValue(this.outcome.schemaVersion, actProps));
    }

    public boolean hasScript(CastorHashMap actProps) {
        if (this.script == null || actProps == null) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)Transition.resolveValue(this.script.scriptName, actProps))) {
            return false;
        }
        return !StringUtils.isEmpty((CharSequence)Transition.resolveValue(this.script.scriptVersion, actProps));
    }

    public boolean hasQuery(CastorHashMap actProps) {
        if (this.query == null || actProps == null) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)Transition.resolveValue(this.query.name, actProps))) {
            return false;
        }
        return !StringUtils.isEmpty((CharSequence)Transition.resolveValue(this.query.version, actProps));
    }

    public Schema getSchema(CastorHashMap actProps) throws InvalidDataException, ObjectNotFoundException {
        if (this.hasOutcome(actProps)) {
            try {
                return LocalObjectLoader.getSchema(Transition.resolveValue(this.outcome.schemaName, actProps), Integer.parseInt(Transition.resolveValue(this.outcome.schemaVersion, actProps)));
            }
            catch (NumberFormatException ex) {
                throw new InvalidDataException("Bad schema version number: " + this.outcome.schemaVersion + " (" + Transition.resolveValue(this.outcome.schemaVersion, actProps) + ")");
            }
        }
        return null;
    }

    public Script getScript(CastorHashMap actProps) throws ObjectNotFoundException, InvalidDataException {
        if (this.hasScript(actProps)) {
            try {
                return LocalObjectLoader.getScript(Transition.resolveValue(this.script.scriptName, actProps), Integer.parseInt(Transition.resolveValue(this.script.scriptVersion, actProps)));
            }
            catch (NumberFormatException ex) {
                throw new InvalidDataException("Bad script version number: " + this.script.scriptVersion + " (" + Transition.resolveValue(this.script.scriptVersion, actProps) + ")");
            }
        }
        return null;
    }

    public Query getQuery(CastorHashMap actProps) throws ObjectNotFoundException, InvalidDataException {
        if (this.hasQuery(actProps)) {
            try {
                return LocalObjectLoader.getQuery(Transition.resolveValue(this.query.name, actProps), Integer.parseInt(Transition.resolveValue(this.query.version, actProps)));
            }
            catch (NumberFormatException ex) {
                throw new InvalidDataException("Bad query version number: " + this.query.version + " (" + Transition.resolveValue(this.query.version, actProps) + ")");
            }
        }
        return null;
    }

    @Deprecated
    public String getScriptName(CastorHashMap actProps) {
        try {
            return this.getScript(actProps).getName();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated
    public int getScriptVersion(CastorHashMap actProps) throws InvalidDataException {
        try {
            return this.getScript(actProps).getVersion();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public String toString() {
        return this.getName() + "[id:" + this.getId() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.id == ((Transition)other).id;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getOriginStateId() {
        return this.originStateId;
    }

    public int getTargetStateId() {
        return this.targetStateId;
    }

    public State getOriginState() {
        return this.originState;
    }

    public State getTargetState() {
        return this.targetState;
    }

    public String getReservation() {
        return this.reservation;
    }

    public boolean isErrorHandler() {
        return this.errorHandler;
    }

    public String getEnabledProp() {
        return this.enabledProp;
    }

    public boolean isRequiresActive() {
        return this.requiresActive;
    }

    public boolean isFinishing() {
        return this.finishing;
    }

    public boolean isReinitializes() {
        return this.reinitializes;
    }

    public String getRoleOverride() {
        return this.roleOverride;
    }

    public TransitionOutcome getOutcome() {
        return this.outcome;
    }

    public TransitionScript getScript() {
        return this.script;
    }

    public TransitionQuery getQuery() {
        return this.query;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOriginStateId(int originStateId) {
        this.originStateId = originStateId;
    }

    public void setTargetStateId(int targetStateId) {
        this.targetStateId = targetStateId;
    }

    public void setOriginState(State originState) {
        this.originState = originState;
    }

    public void setReservation(String reservation) {
        this.reservation = reservation;
    }

    public void setErrorHandler(boolean errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setEnabledProp(String enabledProp) {
        this.enabledProp = enabledProp;
    }

    public void setRequiresActive(boolean requiresActive) {
        this.requiresActive = requiresActive;
    }

    public void setFinishing(boolean finishing) {
        this.finishing = finishing;
    }

    public void setRoleOverride(String roleOverride) {
        this.roleOverride = roleOverride;
    }

    public void setOutcome(TransitionOutcome outcome) {
        this.outcome = outcome;
    }

    public void setScript(TransitionScript script) {
        this.script = script;
    }

    public void setQuery(TransitionQuery query) {
        this.query = query;
    }
}

