/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process;

import java.net.InetAddress;
import java.util.HashMap;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.InvalidTransitionException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.proxy.MemberSubscription;
import org.cristalise.kernel.entity.proxy.ProxyObserver;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.persistency.ClusterStorage;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.StandardClient;
import org.cristalise.kernel.scripting.ScriptErrorException;
import org.cristalise.kernel.utils.Logger;

public class UserCodeProcess
extends StandardClient
implements ProxyObserver<Job>,
Runnable {
    private final int START;
    private final int COMPLETE;
    private final int ERROR;
    public static final String DEFAULT_ROLE = "UserCode";
    public static final String STATE_MACHINE_START_TRANSITION = "StateMachine.startTransition";
    public static final String STATE_MACHINE_COMPLETE_TRANSITION = "StateMachine.completeTransition";
    public static final String STATE_MACHINE_ERROR_TRANSITION = "StateMachine.errorTransition";
    public static final String USERCODE_IGNORE = "USERCODE_IGNORE";
    protected static boolean active = true;
    protected final HashMap<String, C2KLocalObject> jobs = new HashMap();

    public UserCodeProcess() throws InvalidDataException, ObjectNotFoundException {
        this(DEFAULT_ROLE);
    }

    public UserCodeProcess(String propPrefix) throws InvalidDataException, ObjectNotFoundException {
        if (propPrefix == null) {
            propPrefix = DEFAULT_ROLE;
        }
        StateMachine sm = UserCodeProcess.getRequiredStateMachine(propPrefix, null, "boot/SM/Default.xml");
        this.START = this.getValidTransitionID(sm, propPrefix + "." + STATE_MACHINE_START_TRANSITION, "Start");
        this.ERROR = this.getValidTransitionID(sm, propPrefix + "." + STATE_MACHINE_ERROR_TRANSITION, "Suspend");
        this.COMPLETE = this.getValidTransitionID(sm, propPrefix + "." + STATE_MACHINE_COMPLETE_TRANSITION, "Complete");
    }

    private int getValidTransitionID(StateMachine sm, String propertyName, String defaultValue) throws InvalidDataException {
        String propertyValue = Gateway.getProperties().getString(propertyName, defaultValue);
        if (USERCODE_IGNORE.equals(propertyValue)) {
            return -1;
        }
        return sm.getValidTransitionID(propertyValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName("Usercode Process");
        this.agent.subscribe(new MemberSubscription<Job>(this, ClusterType.JOB.getName(), true));
        while (active) {
            Job thisJob = this.getActualJob();
            if (thisJob != null) {
                String jobKey = thisJob.getItemPath() + ":" + thisJob.getStepPath();
                int transitionId = thisJob.getTransition().getId();
                try {
                    if (transitionId == this.START) {
                        this.start(thisJob, jobKey);
                    } else if (transitionId == this.COMPLETE) {
                        this.complete(thisJob, jobKey);
                    }
                }
                catch (InvalidTransitionException invalidTransitionException) {
                }
                catch (Exception ex) {
                    Logger.error("Error executing job:" + thisJob, new Object[0]);
                    Logger.error(ex);
                }
            }
            try {
                HashMap<String, C2KLocalObject> hashMap = this.jobs;
                synchronized (hashMap) {
                    if (this.jobs.size() == 0) {
                        Logger.msg("UserCodeProcess.run() - Sleeping", new Object[0]);
                        while (active && this.jobs.size() == 0) {
                            this.jobs.wait(2000L);
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        try {
            Gateway.close();
        }
        catch (Exception ex) {
            Logger.error(ex);
        }
    }

    public void start(Job thisJob, String jobKey) throws AccessRightsException, InvalidDataException, InvalidTransitionException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, ScriptErrorException, InvalidCollectionModification {
        Logger.msg(5, "UserCodeProcess.start() - job:" + thisJob, new Object[0]);
        if (this.assessStartConditions(thisJob)) {
            Logger.msg(5, "UserCodeProcess.start() - Attempting to start", new Object[0]);
            this.agent.execute(thisJob);
        } else {
            Logger.msg(5, "UserCodeProcess.start() - Start conditions failed " + thisJob.getStepName() + " in " + thisJob.getItemPath(), new Object[0]);
        }
    }

    public void complete(Job thisJob, String jobKey) throws Exception {
        Logger.msg(5, "UserCodeProcess.complete() - job:" + thisJob, new Object[0]);
        this.runUserCodeLogic(thisJob, this.getErrorJob(thisJob, this.ERROR));
    }

    public boolean assessStartConditions(Job job) {
        return true;
    }

    public void runUserCodeLogic(Job job, Job errorJob) throws AccessRightsException, InvalidDataException, InvalidTransitionException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, InvalidCollectionModification, ScriptErrorException {
        if (errorJob == null) {
            this.agent.execute(job);
        } else {
            this.agent.execute(job, errorJob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Job getActualJob() {
        Job thisJob = null;
        HashMap<String, C2KLocalObject> hashMap = this.jobs;
        synchronized (hashMap) {
            if (this.jobs.size() > 0) {
                thisJob = UserCodeProcess.getJob(this.jobs, this.COMPLETE);
                if (thisJob == null) {
                    thisJob = UserCodeProcess.getJob(this.jobs, this.START);
                }
                if (thisJob == null) {
                    Logger.error("No supported jobs, but joblist is not empty! Discarding remaining jobs", new Object[0]);
                    this.jobs.clear();
                } else {
                    this.jobs.remove(ClusterStorage.getPath(thisJob));
                }
            }
        }
        return thisJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Job getErrorJob(Job completeJob, int errorTrans) {
        Job errorJob = null;
        HashMap<String, C2KLocalObject> hashMap = this.jobs;
        synchronized (hashMap) {
            for (C2KLocalObject c2kLocalObject : this.jobs.values()) {
                Job thisJob = (Job)c2kLocalObject;
                if (!thisJob.getItemUUID().equals(completeJob.getItemUUID()) || thisJob.getTransition().getId() != errorTrans) continue;
                Logger.msg(5, "UserCodeProcess.getErrorJob() - job:" + thisJob, new Object[0]);
                errorJob = thisJob;
            }
        }
        return errorJob;
    }

    private static Job getJob(HashMap<String, C2KLocalObject> jobs, int transition) {
        for (C2KLocalObject c2kLocalObject : jobs.values()) {
            Job thisJob = (Job)c2kLocalObject;
            if (thisJob.getTransition().getId() != transition) continue;
            Logger.msg(1, "=================================================================", new Object[0]);
            Logger.msg(5, "UserCodeProcess.getJob() - job:" + thisJob, new Object[0]);
            return thisJob;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Job job) {
        HashMap<String, C2KLocalObject> hashMap = this.jobs;
        synchronized (hashMap) {
            this.jobs.put(job.getClusterPath(), job);
            this.jobs.notify();
            Logger.msg(7, "UserCodeProcess.add() - Added job:" + job, new Object[0]);
        }
    }

    @Override
    public void control(String control, String msg) {
        if ("Error".equals(control)) {
            Logger.error("Error in job subscription: " + msg, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String id) {
        HashMap<String, C2KLocalObject> hashMap = this.jobs;
        synchronized (hashMap) {
            Job job = (Job)this.jobs.remove(id);
            Logger.msg(7, "UserCodeProcess.remove() - Removed job:" + job, new Object[0]);
        }
    }

    public String getDesc() {
        String role = Gateway.getProperties().getString("UserCode.roleOverride", DEFAULT_ROLE);
        return "Usercode Process for role " + role;
    }

    public static void shutdown() {
        active = false;
    }

    public static void main(String[] args) {
        int status = 0;
        try {
            Gateway.init(UserCodeProcess.readC2KArgs(args));
            String prefix = Gateway.getProperties().getString("UserCode.roleOverride", DEFAULT_ROLE);
            UserCodeProcess proc = new UserCodeProcess(prefix);
            proc.login(Gateway.getProperties().getString(prefix + ".agent", InetAddress.getLocalHost().getHostName()), Gateway.getProperties().getString(prefix + ".password", "uc"), Gateway.getProperties().getString("AuthResource", "Cristal"));
            new Thread(proc).start();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    UserCodeProcess.shutdown();
                }
            }));
        }
        catch (Exception ex) {
            Logger.error(ex);
            try {
                Gateway.close();
            }
            catch (Exception ex1) {
                Logger.error(ex1);
            }
            status = 1;
            System.exit(status);
        }
    }
}

