/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process.resource;

public enum BuiltInResources {
    PROPERTY_DESC_RESOURCE("property", "PropertyDescription", null, null),
    ACTIVITY_DESC_RESOURCE("AC", "ActivityDef", null, null),
    MODULE_RESOURCE("module", "Module", "/desc/Module", "ManageModule"),
    SCHEMA_RESOURCE("OD", "Schema", "/desc/Schema", "ManageSchema"),
    SCRIPT_RESOURCE("SC", "Script", "/desc/Script", "ManageScript"),
    QUERY_RESOURCE("query", "Query", "/desc/Query", "ManageQuery"),
    STATE_MACHINE_RESOURCE("SM", "StateMachine", "/desc/StateMachine", "ManageStateMachine"),
    COMP_ACT_DESC_RESOURCE("CA", "CompositeActivityDef", "/desc/ActivityDesc", "ManageCompositeActDef"),
    ELEM_ACT_DESC_RESOURCE("EA", "ElementaryActivityDef", "/desc/ActivityDesc", "ManageElementaryActDef");

    private String typeCode;
    private String schemaName;
    private String typeRoot;
    private String workflowDef;

    private BuiltInResources(String code, String schema, String root, String wf) {
        this.typeCode = code;
        this.schemaName = schema;
        this.typeRoot = root;
        this.workflowDef = wf;
    }

    public String toString() {
        return this.getTypeCode();
    }

    public static BuiltInResources getValue(String typeCode) {
        for (BuiltInResources res : BuiltInResources.values()) {
            if (!res.getTypeCode().equals(typeCode) && !res.name().equals(typeCode)) continue;
            return res;
        }
        return null;
    }

    public String getTypeCode() {
        return this.typeCode;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTypeRoot() {
        return this.typeRoot;
    }

    public String getWorkflowDef() {
        return this.workflowDef;
    }
}

